/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.item.ICutterItem;
import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.render.model.BlockCopyModel;
import ic2.core.block.render.model.ModelCable;
import ic2.core.block.wiring.cables.IWireInformation;
import ic2.core.block.wiring.cables.WireRegistry;
import ic2.core.block.wiring.tile.TileEntityCable;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCable
extends BlockMultiID
implements ICustomModeledBlock,
IBootable {
    public static PropertyInteger insulation = PropertyInteger.func_177719_a((String)"insulation", (int)0, (int)3);
    public static PropertyInteger foamed = PropertyInteger.func_177719_a((String)"foamed", (int)0, (int)2);
    public static PropertyEnum<IEnergyConductorColored.WireColor> color = PropertyEnum.func_177709_a((String)"wirecolor", IEnergyConductorColored.WireColor.class);
    public static WireRegistry registry = WireRegistry.instance;

    public BlockCable() {
        super(Material.field_151573_f);
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185854_g);
        this.setUnlocalizedName(Ic2BlockLang.cableBlock);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public void onLoad() {
        Ic2States.copperCable = this.func_176203_a(0);
        Ic2States.goldCable = this.func_176203_a(1);
        Ic2States.ironCable = this.func_176203_a(2);
        Ic2States.glassFiberCable = this.func_176203_a(3);
        Ic2States.tinCable = this.func_176203_a(4);
        Ic2States.detectorCable = this.func_176203_a(5);
        Ic2States.splitterCable = this.func_176203_a(6);
        Ic2States.bronzeCable = this.func_176203_a(7);
        Ic2States.plasmaCable = this.func_176203_a(8);
    }

    public boolean func_149744_f(IBlockState state) {
        return registry.getInfoFromType(this.func_176201_c(state)).canProvideRedstone();
    }

    @Override
    public boolean hasFacing() {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCable) {
            IBlockState state;
            TileEntityCable cable = (TileEntityCable)tile;
            if (cable.foamed > 1 && (state = cable.storage.getEntry(side.func_176745_a()).getModelState()) != null) {
                try {
                    return state.isSideSolid(world, pos, side);
                }
                catch (Exception e) {
                    return true;
                }
            }
        }
        return super.isSideSolid(base_state, world, pos, side);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public List<IBlockState> getValidStates() {
        return new ArrayList<IBlockState>();
    }

    @Override
    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        IWireInformation info = registry.getInfoFromType(meta);
        if (info.hasCustomTileEntity()) {
            return info.getCustomTileEntity(meta);
        }
        return new TileEntityCable(meta);
    }

    @Override
    public List<Integer> getValidMetas() {
        ArrayList<Integer> metas = new ArrayList<Integer>();
        int types = Math.min(16, registry.getTypeAmount());
        for (int i = 0; i < types; ++i) {
            metas.add(i);
        }
        return metas;
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        if (!player.func_70093_af()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)tile;
                if (cable.foamed > 0) {
                    try {
                        IBlockState realState = cable.storage.getEntry(target.field_178784_b.func_176745_a()).getModelState();
                        return realState.func_177230_c().getPickBlock(realState, target, world, pos, player);
                    }
                    catch (Exception realState) {}
                }
            }
        } else {
            IWorldNameable name;
            TileEntity tile = world.func_175625_s(target.func_178782_a());
            if (tile instanceof IWorldNameable && (name = (IWorldNameable)tile).func_145818_k_()) {
                ItemStack stack = new ItemStack((Block)this, 1, this.func_176201_c(state));
                stack.func_151001_c(name.func_70005_c_());
                return stack;
            }
        }
        return new ItemStack(this.func_180660_a(state, world.field_73012_v, 0), 1, this.func_180651_a(state));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tile;
        if (player.func_70093_af() && (tile = world.func_175625_s(pos)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)tile;
            if (cable.foamed > 0) {
                cable.changeFoam((byte)0);
                return false;
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        return Ic2Icons.getTextures(registry.getContainerFromMeta(meta).getInfo().getTextureSheet(meta));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{this.getMetadataProperty(), active, insulation, color, foamed});
    }

    @Override
    public IBlockState getDefaultBlockState() {
        return super.getDefaultBlockState().func_177226_a((IProperty)insulation, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)).func_177226_a(color, (Comparable)((Object)IEnergyConductorColored.WireColor.Blank)).func_177226_a((IProperty)foamed, (Comparable)Integer.valueOf(0));
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)tile;
            return state.func_177226_a((IProperty)insulation, (Comparable)Integer.valueOf(cable.insulation)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(cable.getActive())).func_177226_a(color, (Comparable)((Object)cable.cableColor)).func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(this.func_176201_c(state))).func_177226_a((IProperty)foamed, (Comparable)Integer.valueOf(cable.foamed));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        try {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)tile;
                if (cable.foamed > 1) {
                    return new BlockStateContainerIC2.IC2BlockState(state, cable.getStorage().getQuads());
                }
                return new BlockStateContainerIC2.IC2BlockState(state, cable.getConnections());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getExtendedState(state, world, pos);
    }

    @Override
    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Ic2Items.copperCable.func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        return registry.getMetaFromType((Integer)state.func_177229_b((IProperty)this.getMetadataProperty()), (Integer)state.func_177229_b((IProperty)insulation));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing side) {
        return this.getIconSheet(this.func_176201_c(state))[registry.getInfoFromType(this.func_176201_c(state)).getTexture((Integer)state.func_177229_b((IProperty)insulation), (IEnergyConductorColored.WireColor)((Object)state.func_177229_b(color)), (Boolean)state.func_177229_b((IProperty)active))];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return this.getIconSheet(this.func_176201_c(state))[registry.getInfoFromType(this.func_176201_c(state)).getTexture((Integer)state.func_177229_b((IProperty)insulation), (IEnergyConductorColored.WireColor)((Object)state.func_177229_b(color)), (Boolean)state.func_177229_b((IProperty)active))];
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        byte foamed;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCable && (foamed = ((TileEntityCable)tile).foamed) > 1) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getCommonBox(state, source, pos);
    }

    private AxisAlignedBB getCommonBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityCable)) {
            return new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
        }
        TileEntityCable cable = (TileEntityCable)tile;
        if (cable.foamed > 0) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        double thickness = this.getCableThickness(this.func_176221_a(state, world, pos)) / 2.0;
        double minX = 0.5 - thickness;
        double minY = 0.5 - thickness;
        double minZ = 0.5 - thickness;
        double maxX = 0.5 + thickness;
        double maxY = 0.5 + thickness;
        double maxZ = 0.5 + thickness;
        if (cable.canConnect(EnumFacing.WEST)) {
            minX = 0.0;
        }
        if (cable.canConnect(EnumFacing.DOWN)) {
            minY = 0.0;
        }
        if (cable.canConnect(EnumFacing.NORTH)) {
            minZ = 0.0;
        }
        if (cable.canConnect(EnumFacing.EAST)) {
            maxX = 1.0;
        }
        if (cable.canConnect(EnumFacing.UP)) {
            maxY = 1.0;
        }
        if (cable.canConnect(EnumFacing.SOUTH)) {
            maxZ = 1.0;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public double getCableThickness(IBlockState state) {
        return registry.getInfoFromType(this.func_176201_c(state)).getConductorThickness((Integer)state.func_177229_b((IProperty)insulation)) / 16.0;
    }

    private int convertToPixel(IBlockState state) {
        return (int)(16.0 * (this.getCableThickness(state) / 2.0));
    }

    public int getMinPixels(IBlockState state) {
        return 8 - this.convertToPixel(state);
    }

    public int getMaxPixels(IBlockState state) {
        return 8 + this.convertToPixel(state);
    }

    @Override
    public List<IBlockState> getValidStateList() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>(2000);
        int types = Math.min(16, registry.getTypeAmount());
        for (int i = 0; i < types; ++i) {
            IWireInformation info = registry.getInfoFromType(i);
            boolean active = info.canBeActive();
            int max = info.getMaxInsulationTypes();
            for (int ins = 0; ins <= max; ++ins) {
                states.addAll(this.createState(i, ins, false, IEnergyConductorColored.WireColor.Blank));
                if (active) {
                    states.addAll(this.createState(i, ins, true, IEnergyConductorColored.WireColor.Blank));
                }
                if (ins == 0 && !info.canColorWithoutInsulation()) continue;
                for (EnumDyeColor color : EnumDyeColor.values()) {
                    states.addAll(this.createState(i, ins, false, IEnergyConductorColored.WireColor.fromColor(color)));
                    if (!active) continue;
                    states.addAll(this.createState(i, ins, true, IEnergyConductorColored.WireColor.fromColor(color)));
                }
            }
        }
        return states;
    }

    @Override
    public List<IBlockState> getValidModelStates() {
        return this.func_176194_O().func_177619_a();
    }

    private List<IBlockState> createState(int meta, int ins, boolean isActive, IEnergyConductorColored.WireColor wireColor) {
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        IBlockState state = this.getDefaultBlockState().func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)insulation, (Comparable)Integer.valueOf(ins)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(isActive)).func_177226_a(color, (Comparable)((Object)wireColor));
        list.add(state);
        list.add(state.func_177226_a((IProperty)foamed, (Comparable)Integer.valueOf(1)));
        list.add(state.func_177226_a((IProperty)foamed, (Comparable)Integer.valueOf(2)));
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromState(IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)foamed) == 1) {
            return BlockCopyModel.getFoamModel(Ic2States.constructionFoamCable);
        }
        if ((Integer)state.func_177229_b((IProperty)foamed) == 2) {
            return BlockCopyModel.getFoamModel(Ic2Icons.getTextures("bcable")[195]);
        }
        return new ModelCable(state, Ic2Icons.getTextures("bcable")[277]);
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCable) {
            return ((TileEntityCable)tile).foamed > 0 ? 255 : 0;
        }
        return 0;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)tile;
            return cable.changeColor(IEnergyConductorColored.WireColor.values()[color.func_176767_b() + 1], side);
        }
        return false;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCable) {
            EnumFacing rotation;
            TileEntityCable cable = (TileEntityCable)tile;
            ItemStack stack = playerIn.func_184586_b(hand);
            if (cable.foamed == 1 && StackUtil.isStackEqual(stack, new ItemStack((Block)Blocks.field_150354_m))) {
                cable.changeFoam((byte)2);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
            if (cable.foamed == 0 && StackUtil.isStackEqual(stack, Ic2Items.constructionFoam.func_77946_l())) {
                cable.changeFoam((byte)1);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.miningPipe) && (rotation = new ClickHelper(hitX, hitY, hitZ, (float)this.getCableThickness(state)).getFacing(facing)) != null && cable.addAnchor(rotation)) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_77973_b() instanceof ICutterItem) {
            ((ICutterItem)stack.func_77973_b()).cutInsulationFrom(stack, worldIn, pos, playerIn);
        }
    }

    @Override
    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return false;
    }

    public static class ClickHelper {
        float x;
        float y;
        float z;
        float offset;

        public ClickHelper(float xHit, float yHit, float zHit, float pixel) {
            this.x = xHit;
            this.y = yHit;
            this.z = zHit;
            this.offset = pixel;
        }

        public ClickHelper(Vec3d hit, float pixel) {
            this.x = (float)hit.field_72450_a;
            this.y = (float)hit.field_72448_b;
            this.z = (float)hit.field_72449_c;
            this.offset = pixel;
        }

        public EnumFacing getFacing(EnumFacing side) {
            float min = 0.5f - this.offset;
            float max = 0.5f + this.offset;
            if (this.x >= min && this.x <= max && this.y >= min && this.y <= max && this.z >= min && this.z <= max) {
                return side;
            }
            if (this.x >= 0.0f && this.x <= min && this.y >= min && this.y <= max && this.z >= min && this.z <= max) {
                return EnumFacing.WEST;
            }
            if (this.x >= max && this.x <= 1.0f && this.y >= min && this.y <= max && this.z >= min && this.z <= max) {
                return EnumFacing.EAST;
            }
            if (this.x >= min && this.x <= max && this.y >= 0.0f && this.y <= min && this.z >= min && this.z <= max) {
                return EnumFacing.DOWN;
            }
            if (this.x >= min && this.x <= max && this.y >= max && this.y <= this.y && this.z >= min && this.z <= max) {
                return EnumFacing.UP;
            }
            if (this.x >= min && this.x <= max && this.y >= min && this.y <= max && this.z >= 0.0f && this.z <= min) {
                return EnumFacing.NORTH;
            }
            if (this.x >= min && this.x <= max && this.y >= min && this.y <= max && this.z >= max && this.z <= 1.0f) {
                return EnumFacing.SOUTH;
            }
            return null;
        }
    }
}

