/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.machine.med.TileEntityOreScanner;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OreScannerComp
extends GuiComponent {
    public static int[][] slotPositions = new int[][]{{30, 37}, {30, 54}, {30, 71}, {30, 89}, {30, 107}};
    TileEntityOreScanner scanner;

    public OreScannerComp(TileEntityOreScanner tile) {
        super(Ic2GuiComp.nullBox);
        this.scanner = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.FrontgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.registerButton(new IC2Button(0, x + 145, y + 110, 20, 10, "-"));
        gui.registerButton(new IC2Button(1, x + 145, y + 35, 20, 10, "+"));
        gui.registerButton(new IC2Button(2, x + 132, y + 70, 35, 10, Ic2GuiLang.scannerReset));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        if (this.scanner.state != TileEntityOreScanner.ProcessState.Finished) {
            int amount = (int)((double)this.scanner.currentBlocks / (double)this.scanner.maxBlocks * 100.0);
            gui.drawString(amount + "%", 75, 75, 0x404040);
            return;
        }
        for (int i = 0; i < 5; ++i) {
            int amount = this.scanner.storage.getStorage(this.scanner.storage.getStackInSlot(i));
            if (amount <= 0) continue;
            gui.drawString(amount + "x", slotPositions[i][0], slotPositions[i][1], 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.scanner.getNetwork().initiateClientTileEntityEvent(this.scanner, -1);
        } else if (id == 1) {
            this.scanner.getNetwork().initiateClientTileEntityEvent(this.scanner, 1);
        } else if (id == 2) {
            this.scanner.getNetwork().initiateClientTileEntityEvent(this.scanner, 0);
        }
    }
}

