/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.api.classic.item.IFuelableItem;
import ic2.api.item.IBoxable;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemFuelCan
extends ItemIC2
implements IFuelableItem,
IBoxable,
IBootable {
    public ItemFuelCan() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.fuelCanItem);
        this.func_77625_d(1);
    }

    @Override
    public void onLoad() {
        Ic2Items.fuelCan = new ItemStack((Item)this);
        Ic2Items.fullFuelCan = new ItemStack((Item)this, 1, 1);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77960_j() == 1) {
            tooltip.add(Ic2InfoLang.machineFuel.getLocalizedFormatted(this.getFuel(stack), this.getMaxFuel(stack)));
        }
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 18 + meta;
    }

    @Override
    public ItemStack fill(ItemStack emptyItem, int amount) {
        ItemStack filled = new ItemStack((Item)this, 1, 1);
        this.setFuel(filled, amount);
        this.setMaxFuel(filled, amount);
        return filled;
    }

    @Override
    public boolean canFill(ItemStack stack) {
        return stack.func_77960_j() == 0;
    }

    @Override
    public boolean hasFuel(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    public int drainFuel(ItemStack stack, boolean doDrain) {
        int fuel = 500;
        int stored = this.getFuel(stack);
        if (stored < fuel) {
            fuel = stored;
        }
        if (doDrain) {
            int newValue = stored - fuel;
            if (newValue <= 0) {
                stack.func_77978_p().func_150296_c().clear();
                this.setDamage(stack, 0);
            } else {
                this.setFuel(stack, newValue);
            }
        }
        return fuel;
    }

    public void setFuel(ItemStack stack, int amount) {
        StackUtil.getOrCreateNbtData(stack).func_74768_a("Fuel", amount);
    }

    public void setMaxFuel(ItemStack stack, int amount) {
        StackUtil.getOrCreateNbtData(stack).func_74768_a("MaxFuel", amount);
    }

    public int getFuel(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("Fuel");
    }

    public int getMaxFuel(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("MaxFuel");
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getFuel(stack) / (double)this.getMaxFuel(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.fuelCan;
            }
            case 1: {
                return Ic2ItemLang.fuelCanFilled;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack stack) {
        return true;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    @Override
    public int getFuel(ItemStack stack, int requested, boolean doDrain) {
        if (stack.func_77960_j() == 0) {
            return 0;
        }
        int stored = this.getFuel(stack);
        int delivered = Math.min(requested, stored);
        if (doDrain) {
            int left = stored - delivered;
            if (left <= 0) {
                stack.func_77978_p().func_150296_c().clear();
                this.setDamage(stack, 0);
            } else {
                this.setFuel(stack, left);
            }
        }
        return delivered;
    }

    @Deprecated
    public boolean func_77634_r() {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (itemStack.func_77960_j() == 0) {
            return itemStack.func_77946_l();
        }
        ItemStack copy = itemStack.func_77946_l();
        this.drainFuel(copy, true);
        copy.func_190920_e(1);
        return copy;
    }
}

