/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.tileentity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntityCommandBlock;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableCommandData;
import org.spongepowered.api.data.manipulator.mutable.CommandData;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.data.manipulator.mutable.SpongeCommandData;
import org.spongepowered.common.data.processor.common.AbstractTileEntityDataProcessor;
import org.spongepowered.common.mixin.core.tileentity.CommandBlockBaseLogicAccessor;
import org.spongepowered.common.text.SpongeTexts;

public class TileEntityCommandDataProcessor
extends AbstractTileEntityDataProcessor<TileEntityCommandBlock, CommandData, ImmutableCommandData> {
    public TileEntityCommandDataProcessor() {
        super(TileEntityCommandBlock.class);
    }

    @Override
    public Optional<CommandData> fill(DataContainer container, CommandData commandData) {
        if (!container.contains(Keys.LAST_COMMAND_OUTPUT.getQuery(), Keys.SUCCESS_COUNT.getQuery(), Keys.COMMAND.getQuery(), Keys.TRACKS_OUTPUT.getQuery())) {
            return Optional.empty();
        }
        Optional lastCommandOutput = (Optional)container.get(Keys.LAST_COMMAND_OUTPUT.getQuery()).get();
        int successCount = container.getInt(Keys.SUCCESS_COUNT.getQuery()).get();
        String command = container.getString(Keys.COMMAND.getQuery()).get();
        boolean tracksOutput = container.getBoolean(Keys.TRACKS_OUTPUT.getQuery()).get();
        commandData.set(Keys.LAST_COMMAND_OUTPUT, lastCommandOutput);
        commandData.set(Keys.SUCCESS_COUNT, successCount);
        commandData.set(Keys.COMMAND, command);
        commandData.set(Keys.TRACKS_OUTPUT, tracksOutput);
        return Optional.of(commandData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean doesDataExist(TileEntityCommandBlock entity) {
        return true;
    }

    @Override
    protected boolean set(TileEntityCommandBlock entity, Map<Key<?>, Object> keyValues) {
        CommandBlockBaseLogic logic = entity.func_145993_a();
        logic.func_145750_b(SpongeTexts.toComponent(((Optional)keyValues.get(Keys.LAST_COMMAND_OUTPUT)).orElse(Text.of())));
        ((CommandBlockBaseLogicAccessor)logic).accessor$setCommandStored((String)keyValues.get(Keys.COMMAND));
        ((CommandBlockBaseLogicAccessor)logic).accessor$setSuccessCount((Integer)keyValues.get(Keys.SUCCESS_COUNT));
        logic.func_175573_a(((Boolean)keyValues.get(Keys.TRACKS_OUTPUT)).booleanValue());
        entity.func_70296_d();
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(TileEntityCommandBlock entity) {
        CommandBlockBaseLogic logic = entity.func_145993_a();
        HashMap values = Maps.newHashMapWithExpectedSize((int)4);
        Optional lastCommandOutput = logic.func_145749_h() != null ? Optional.of(SpongeTexts.toText(logic.func_145749_h())) : Optional.empty();
        values.put(Keys.LAST_COMMAND_OUTPUT, lastCommandOutput);
        values.put(Keys.COMMAND, logic.func_145753_i());
        values.put(Keys.SUCCESS_COUNT, logic.func_145760_g());
        values.put(Keys.TRACKS_OUTPUT, logic.func_175571_m());
        return values;
    }

    @Override
    protected CommandData createManipulator() {
        return new SpongeCommandData();
    }
}

