/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property.store.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.spongepowered.api.data.property.block.InstrumentProperty;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.InstrumentTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.common.data.property.store.common.AbstractBlockPropertyStore;

public class InstrumentPropertyStore
extends AbstractBlockPropertyStore<InstrumentProperty> {
    public InstrumentPropertyStore() {
        super(true);
    }

    @Override
    protected Optional<InstrumentProperty> getForBlock(@Nullable Location<?> location, IBlockState block) {
        return Optional.of(new InstrumentProperty(this.getInstrumentType(block)));
    }

    private InstrumentType getInstrumentType(IBlockState block) {
        Block blockType = block.func_177230_c();
        if (blockType == Blocks.field_150435_aG) {
            return InstrumentTypes.FLUTE;
        }
        if (blockType == Blocks.field_150340_R) {
            return InstrumentTypes.BELL;
        }
        if (blockType == Blocks.field_150325_L) {
            return InstrumentTypes.GUITAR;
        }
        if (blockType == Blocks.field_150403_cj) {
            return InstrumentTypes.CHIME;
        }
        if (blockType == Blocks.field_189880_di) {
            return InstrumentTypes.XYLOPHONE;
        }
        Material material = block.func_177230_c().func_149688_o(block);
        if (material == Material.field_151576_e) {
            return InstrumentTypes.BASS_DRUM;
        }
        if (material == Material.field_151595_p) {
            return InstrumentTypes.SNARE;
        }
        if (material == Material.field_151592_s) {
            return InstrumentTypes.HIGH_HAT;
        }
        if (material == Material.field_151575_d) {
            return InstrumentTypes.BASS_ATTACK;
        }
        return InstrumentTypes.HARP;
    }
}

