/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;

public class InventoryPacketContext
extends PacketContext<InventoryPacketContext> {
    private int oldHighlightedSlotId;

    public InventoryPacketContext(PacketState<? extends InventoryPacketContext> state) {
        super(state);
    }

    public int getOldHighlightedSlotId() {
        return this.oldHighlightedSlotId;
    }

    public InventoryPacketContext setOldHighlightedSlot(int highlightedSlotId) {
        this.oldHighlightedSlotId = highlightedSlotId;
        return this;
    }

    @Override
    public boolean hasCaptures() {
        if (!((ContainerBridge)this.packetPlayer.field_71070_bA).bridge$getPreviewTransactions().isEmpty()) {
            return true;
        }
        if (!((TrackedInventoryBridge)this.packetPlayer.field_71070_bA).bridge$getCapturedSlotTransactions().isEmpty()) {
            return true;
        }
        if (this.state == PacketPhase.Inventory.DROP_ITEMS) {
            return true;
        }
        if (this.state == PacketPhase.Inventory.DROP_ITEM_OUTSIDE_WINDOW) {
            return true;
        }
        if (this.state == PacketPhase.Inventory.OPEN_INVENTORY) {
            return true;
        }
        if (this.state == PacketPhase.Inventory.PLACE_RECIPE) {
            return true;
        }
        if (this.state == PacketPhase.Inventory.SWAP_HAND_ITEMS) {
            return true;
        }
        if (this.state == PacketPhase.Inventory.SWITCH_HOTBAR_SCROLL) {
            return true;
        }
        if (this.state == PacketPhase.Inventory.PRIMARY_INVENTORY_CLICK || this.state == PacketPhase.Inventory.SECONDARY_INVENTORY_CLICK || this.state == PacketPhase.Inventory.MIDDLE_INVENTORY_CLICK || this.state == PacketPhase.Inventory.DROP_ITEM_WITH_HOTKEY || this.state == PacketPhase.Inventory.PRIMARY_INVENTORY_SHIFT_CLICK || this.state == PacketPhase.Inventory.SECONDARY_INVENTORY_SHIFT_CLICK || this.state == PacketPhase.Inventory.SWITCH_HOTBAR_NUMBER_PRESS || this.state == PacketPhase.Inventory.DROP_ITEM_OUTSIDE_WINDOW_NOOP) {
            return true;
        }
        ((TrackedInventoryBridge)this.packetPlayer.field_71070_bA).bridge$setCaptureInventory(false);
        return super.hasCaptures();
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s + "- %s: %s", "HighlightedSlotId", this.oldHighlightedSlotId);
    }

    @Override
    protected void reset() {
        super.reset();
        this.oldHighlightedSlotId = 0;
    }
}

