/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseContext;

public class WorldTickContext
extends ListenerPhaseContext<WorldTickContext> {
    @Nullable
    private net.minecraft.world.World tickingWorld;

    WorldTickContext(IPhaseState<WorldTickContext> state) {
        super(state);
    }

    public WorldTickContext world(net.minecraft.world.World world) {
        this.tickingWorld = world;
        return this;
    }

    public net.minecraft.world.World getWorld() {
        return (net.minecraft.world.World)Preconditions.checkNotNull((Object)this.tickingWorld, (Object)"Ticking World is null");
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent);
        if (!((WorldBridge)this.getWorld()).bridge$isFake()) {
            printer.add(s + "- %s: %s", "TickingWorld", ((World)this.getWorld()).getName());
        } else {
            printer.add(s + "- %s: %s", "Ticking World", "Pseudo Fake World?" + this.tickingWorld);
        }
        return printer;
    }

    @Override
    protected void reset() {
        super.reset();
        this.tickingWorld = null;
    }
}

