/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.bridge.inventory.LensProviderBridge;
import org.spongepowered.common.bridge.item.inventory.InventoryBridge;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.DefaultImplementedAdapterInventory;
import org.spongepowered.common.item.inventory.adapter.impl.SlotCollectionIterator;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.item.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.item.inventory.lens.impl.ReusableLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class AbstractInventoryAdapter
implements InventoryAdapter,
DefaultImplementedAdapterInventory,
InventoryBridge,
Inventory {
    public static final Translation DEFAULT_NAME = new SpongeTranslation("inventory.default.title");
    private final Fabric inventory;
    protected final SlotProvider slots;
    protected final Lens lens;
    protected final List<Inventory> children = new ArrayList<Inventory>();
    protected Inventory parent;
    @Nullable
    protected Inventory next;
    @Nullable
    private Iterable<Slot> slotIterator;

    public AbstractInventoryAdapter(Fabric inventory) {
        this(inventory, null, null);
    }

    @Override
    public Inventory root() {
        return this.parent() == this ? this : this.parent().root();
    }

    public <T extends Lens> AbstractInventoryAdapter(Fabric inventory, Class<T> lensType) {
        this.inventory = inventory;
        this.parent = this;
        if (inventory.fabric$getSize() == 0) {
            this.slots = new SlotCollection(0);
            this.lens = new DefaultEmptyLens(this);
        } else {
            ReusableLens<Lens> lens = ReusableLens.getLens(lensType, this, () -> this.initSlots(inventory, this.parent), slots -> new DefaultIndexedLens(0, inventory.fabric$getSize(), (Class<? extends Inventory>)this.getClass(), (SlotProvider)slots));
            this.slots = lens.getSlots();
            this.lens = lens.getLens();
        }
    }

    public AbstractInventoryAdapter(Fabric inventory, @Nullable Lens root, @Nullable Inventory parent) {
        this.inventory = inventory;
        this.parent = parent == null ? this : parent;
        this.slots = this.initSlots(inventory, parent);
        this.lens = root != null ? root : (Lens)Preconditions.checkNotNull((Object)this.initRootLens(), (Object)"root lens");
    }

    private SlotProvider initSlots(Fabric inventory, @Nullable Inventory parent) {
        if (parent instanceof InventoryAdapter) {
            return ((InventoryAdapter)((Object)parent)).bridge$getSlotProvider();
        }
        return new SlotCollection(inventory.fabric$getSize());
    }

    @Override
    public Inventory parent() {
        return this.parent;
    }

    protected Lens initRootLens() {
        if (this instanceof LensProviderBridge) {
            return ((LensProviderBridge)((Object)this)).bridge$rootLens(this.inventory, this);
        }
        int size = this.inventory.fabric$getSize();
        if (size == 0) {
            return new DefaultEmptyLens(this);
        }
        return new DefaultIndexedLens(0, size, this.getClass(), this.slots);
    }

    @Override
    public SlotProvider bridge$getSlotProvider() {
        return this.slots;
    }

    @Override
    public Lens bridge$getRootLens() {
        return this.lens;
    }

    @Override
    public Fabric bridge$getFabric() {
        return this.inventory;
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        if (this.slotIterator == null) {
            this.slotIterator = SlotCollectionIterator.of(this, this);
        }
        return this.slotIterator;
    }

    public static Optional<Slot> forSlot(Fabric inv, SlotLens slotLens, Inventory parent) {
        return slotLens == null ? Optional.empty() : Optional.ofNullable((Slot)((Object)slotLens.getAdapter(inv, parent)));
    }

    @Override
    public void clear() {
        this.slots().forEach(Inventory::clear);
    }

    @Override
    public PluginContainer getPlugin() {
        if (this.parent != this) {
            return this.parent.getPlugin();
        }
        return null;
    }
}

