/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command.server;

import com.flowpowered.math.vector.Vector3d;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandSummon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;

@Mixin(value={CommandSummon.class})
public abstract class CommandSummonMixin
extends CommandBase {
    @Redirect(method={"execute"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/AnvilChunkLoader;readWorldEntityPos(Lnet/minecraft/nbt/NBTTagCompound;Lnet/minecraft/world/World;DDDZ)Lnet/minecraft/entity/Entity;"))
    private Entity impl$throwConstructEvent(NBTTagCompound nbt, World world, double x, double y, double z, boolean b, MinecraftServer server, ICommandSender sender, String[] args) {
        Class<? extends Entity> entityClass;
        if ("Minecart".equals(nbt.func_74779_i("id"))) {
            nbt.func_74778_a("id", EntityMinecart.Type.values()[nbt.func_74762_e("Type")].func_184954_b());
            nbt.func_82580_o("Type");
        }
        if ((entityClass = SpongeImplHooks.getEntityClass(new ResourceLocation(nbt.func_74779_i("id")))) == null) {
            return null;
        }
        CatalogType type = EntityTypeRegistryModule.getInstance().getForClass((Class)entityClass);
        if (type == null) {
            return null;
        }
        Transform<org.spongepowered.api.world.World> transform = new Transform<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, new Vector3d(x, y, z));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), (EntityType)type, transform);
            SpongeImpl.postEvent(event);
            Entity entity = event.isCancelled() ? null : AnvilChunkLoader.func_186054_a((NBTTagCompound)nbt, (World)world, (double)x, (double)y, (double)z, (boolean)b);
            return entity;
        }
    }

    @Inject(method={"execute"}, at={@At(value="NEW", args={"class=net/minecraft/entity/effect/EntityLightningBolt"})}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$checkLightning(MinecraftServer server, ICommandSender sender, String[] args, CallbackInfo ci, String s, BlockPos blockpos, Vec3d vec3d, double x, double y, double z, World world) {
        Transform<org.spongepowered.api.world.World> transform = new Transform<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, new Vector3d(x, y, z));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), EntityTypes.LIGHTNING, transform);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            } else {
                LightningEvent.Pre lightningPre = SpongeEventFactory.createLightningEventPre(frame.getCurrentCause());
                if (SpongeImpl.postEvent(lightningPre)) {
                    ci.cancel();
                }
            }
        }
    }
}

