/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.ArrayList;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.DamageSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.damage.DamageEventHandler;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseMixin;

@Mixin(value={EntityArmorStand.class})
public abstract class EntityArmorStandMixin
extends EntityLivingBaseMixin {
    @Shadow
    protected abstract void func_175406_a(float var1);

    private void fireDestroyDamageEvent(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), new ArrayList(), (Entity)((Object)this), Math.max(1000.0f, this.func_110143_aJ()));
            if (SpongeImpl.postEvent(event)) {
                cir.setReturnValue(false);
            }
            if (event.getFinalDamage() < (double)this.func_110143_aJ()) {
                this.func_175406_a((float)event.getFinalDamage());
                cir.setReturnValue(false);
            }
        }
    }

    @Inject(method={"attackEntityFrom"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/util/DamageSource;OUT_OF_WORLD:Lnet/minecraft/util/DamageSource;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;setDead()V", ordinal=0)}, cancellable=true)
    private void fireDamageEventOutOfWorld(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Inject(method={"attackEntityFrom"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/DamageSource;isExplosion()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;dropContents()V")}, cancellable=true)
    private void fireDamageEventExplosion(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Redirect(method={"attackEntityFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;damageArmorStand(F)V"))
    private void fireDamageEventDamage(EntityArmorStand self, float effectiveAmount, DamageSource source, float originalAmount) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), new ArrayList(), (Entity)((Object)this), effectiveAmount);
            if (!SpongeImpl.postEvent(event)) {
                this.func_175406_a((float)event.getFinalDamage());
            }
        }
    }

    @Inject(method={"attackEntityFrom"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/DamageSource;isCreativePlayer()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;playBrokenSound()V")}, cancellable=true)
    private void fireDamageEventCreativePunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Inject(method={"attackEntityFrom"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/item/EntityArmorStand;punchCooldown:J", opcode=180))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setEntityState(Lnet/minecraft/entity/Entity;B)V")}, cancellable=true)
    private void fireDamageEventFirstPunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), new ArrayList(), (Entity)((Object)this), 0.0);
            if (SpongeImpl.postEvent(event)) {
                cir.setReturnValue(false);
            }
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;dropBlock()V")}, cancellable=true)
    private void fireDamageEventSecondPunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Override
    @Overwrite
    public void func_174812_G() {
        super.func_174812_G();
    }
}

