/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.bridge.inventory.LensProviderBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.bridge.item.inventory.InventoryAdapterBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.SlotCollectionIterator;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@NonnullByDefault
@Mixin(value={net.minecraft.inventory.Container.class}, priority=998)
public abstract class ContainerMixin
implements ContainerBridge,
InventoryAdapter,
TrackedInventoryBridge,
InventoryAdapterBridge {
    @Shadow
    public List<net.minecraft.inventory.Slot> field_75151_b;
    @Shadow
    public NonNullList<net.minecraft.item.ItemStack> field_75153_a;
    @Shadow
    protected List<IContainerListener> field_75149_d;
    private boolean impl$spectatorChest;
    private boolean impl$dropCancelled = false;
    private ItemStackSnapshot impl$itemStackSnapshot = ItemStackSnapshot.NONE;
    @Nullable
    private net.minecraft.inventory.Slot impl$lastSlotUsed = null;
    @Nullable
    private CraftItemEvent.Craft impl$lastCraft = null;
    @Nullable
    private Location<World> impl$lastOpenLocation;
    private boolean impl$firePreview = true;
    private boolean impl$inUse = false;
    private boolean impl$captureSuccess = false;
    private boolean impl$captureInventory = false;
    private boolean impl$shiftCraft = false;
    private List<SlotTransaction> impl$capturedSlotTransactions = new ArrayList<SlotTransaction>();
    private List<SlotTransaction> impl$capturedCraftShiftTransactions = new ArrayList<SlotTransaction>();
    private List<SlotTransaction> impl$capturedCraftPreviewTransactions = new ArrayList<SlotTransaction>();
    private boolean impl$isLensInitialized;
    @Nullable
    private Map<Integer, SlotAdapter> impl$adapters;
    @Nullable
    private InventoryArchetype impl$archetype;
    @Nullable
    private Carrier impl$carrier;
    @Nullable
    Predicate<EntityPlayer> impl$canInteractWithPredicate;
    @Nullable
    private LinkedHashMap<IInventory, Set<net.minecraft.inventory.Slot>> impl$allInventories;
    @Nullable
    private net.minecraft.item.ItemStack impl$previousCursor;

    @Shadow
    public abstract NonNullList<net.minecraft.item.ItemStack> func_75138_a();

    @Shadow
    public abstract net.minecraft.inventory.Slot shadow$func_75139_a(int var1);

    @Shadow
    public net.minecraft.item.ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        throw new IllegalStateException("Shadowed.");
    }

    @Override
    public SlotProvider bridge$generateSlotProvider() {
        return ContainerUtil.countSlots((net.minecraft.inventory.Container)this, this.bridge$getFabric());
    }

    @Override
    public Lens bridge$generateLens(SlotProvider slots) {
        if (this.impl$isLensInitialized) {
            return null;
        }
        this.impl$isLensInitialized = true;
        Fabric fabric = this.bridge$getFabric();
        Lens lens = this.impl$spectatorChest ? null : (this instanceof LensProviderBridge ? ((LensProviderBridge)((Object)this)).bridge$rootLens(fabric, this) : (this.func_75138_a().size() == 0 ? new DefaultEmptyLens(this) : ContainerUtil.generateLens((net.minecraft.inventory.Container)this, slots)));
        return lens;
    }

    private Map<Integer, SlotAdapter> impl$getAdapters() {
        if (this.impl$adapters == null) {
            this.impl$adapters = new Int2ObjectArrayMap();
            Lens lens = this.bridge$getRootLens();
            if (lens != null) {
                SlotCollectionIterator iter = new SlotCollectionIterator((Inventory)((Object)this), this.bridge$getFabric(), lens, this.bridge$getSlotProvider());
                for (Slot slot : iter) {
                    this.impl$adapters.put(((SlotAdapter)slot).slotNumber, (SlotAdapter)slot);
                }
            }
        }
        return this.impl$adapters;
    }

    @Override
    public InventoryArchetype bridge$getArchetype() {
        if (this.impl$archetype == null) {
            this.impl$archetype = ContainerUtil.getArchetype((net.minecraft.inventory.Container)this);
        }
        return this.impl$archetype;
    }

    @Override
    public Optional<Carrier> bridge$getCarrier() {
        if (this.impl$carrier == null) {
            this.impl$carrier = ContainerUtil.getCarrier((Container)((Object)this));
        }
        return Optional.ofNullable(this.impl$carrier);
    }

    @Override
    public LinkedHashMap<IInventory, Set<net.minecraft.inventory.Slot>> bridge$getInventories() {
        if (this.impl$allInventories == null) {
            this.impl$allInventories = new LinkedHashMap();
            this.field_75151_b.forEach(slot -> this.impl$allInventories.computeIfAbsent(slot.field_75224_c, i -> new HashSet()).add(slot));
        }
        return this.impl$allInventories;
    }

    @Overwrite
    public void func_75132_a(IContainerListener listener) {
        net.minecraft.inventory.Container container = (net.minecraft.inventory.Container)this;
        if (this.field_75149_d.contains(listener)) {
            listener.func_71110_a(container, this.func_75138_a());
            container.func_75142_b();
        } else {
            this.field_75149_d.add(listener);
            listener.func_71110_a(container, this.func_75138_a());
            container.func_75142_b();
        }
    }

    @Overwrite
    public void func_75142_b() {
        this.bridge$detectAndSendChanges(false);
        this.impl$captureSuccess = true;
    }

    @Override
    public boolean bridge$capturePossible() {
        return this.impl$captureSuccess;
    }

    @Override
    public void bridge$detectAndSendChanges(boolean captureOnly) {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            net.minecraft.inventory.Slot slot = this.field_75151_b.get(i);
            net.minecraft.item.ItemStack itemstack = slot.func_75211_c();
            net.minecraft.item.ItemStack itemstack1 = (net.minecraft.item.ItemStack)this.field_75153_a.get(i);
            if (net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)itemstack1, (net.minecraft.item.ItemStack)itemstack)) continue;
            if (this.impl$captureInventory) {
                ItemStackSnapshot originalItem = itemstack1.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack1).createSnapshot();
                ItemStackSnapshot newItem = itemstack.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack).createSnapshot();
                Slot adapter = null;
                try {
                    adapter = this.bridge$getContainerSlot(i);
                    SlotTransaction newTransaction = new SlotTransaction(adapter, originalItem, newItem);
                    if (this.impl$shiftCraft) {
                        this.impl$capturedCraftShiftTransactions.add(newTransaction);
                    } else {
                        SlotTransaction previewTransaction;
                        if (!this.impl$capturedCraftPreviewTransactions.isEmpty() && (previewTransaction = this.impl$capturedCraftPreviewTransactions.get(0)).equals(newTransaction)) {
                            newTransaction = null;
                        }
                        if (newTransaction != null) {
                            this.impl$capturedSlotTransactions.add(newTransaction);
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    SpongeImpl.getLogger().error("SlotIndex out of LensBounds! Did the Container change after creation?", (Throwable)e);
                }
                if (captureOnly) continue;
            }
            itemstack1 = itemstack.func_77946_l();
            this.field_75153_a.set(i, (Object)itemstack1);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((net.minecraft.inventory.Container)this, i, itemstack1);
            }
        }
        this.impl$markClean();
    }

    protected void impl$markClean() {
    }

    @Inject(method={"addSlotToContainer"}, at={@At(value="HEAD")})
    private void impl$onAddSlotToContainer(net.minecraft.inventory.Slot slotIn, CallbackInfoReturnable<net.minecraft.inventory.Slot> cir) {
        this.impl$isLensInitialized = false;
        this.bridge$setSlotProvider(null);
        this.bridge$setLens(null);
        this.impl$adapters = null;
    }

    @Inject(method={"putStackInSlot"}, at={@At(value="HEAD")})
    private void impl$addTransaction(int slotId, net.minecraft.item.ItemStack itemstack, CallbackInfo ci) {
        net.minecraft.inventory.Slot slot;
        if (this.impl$captureInventory && (slot = this.shadow$func_75139_a(slotId)) != null) {
            ItemStackSnapshot originalItem = slot.func_75211_c().func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)slot.func_75211_c()).createSnapshot();
            ItemStackSnapshot newItem = itemstack.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack).createSnapshot();
            Slot adapter = this.bridge$getContainerSlot(slotId);
            this.impl$capturedSlotTransactions.add(new SlotTransaction(adapter, originalItem, newItem));
        }
    }

    @Nullable
    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;dropItem(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/EntityItem;", ordinal=0))
    private EntityItem impl$RestoreOnDrag(EntityPlayer player, net.minecraft.item.ItemStack itemStackIn, boolean unused) {
        ItemStackSnapshot original = ItemStackUtil.snapshotOf(itemStackIn);
        EntityItem entityItem = player.func_71019_a(itemStackIn, unused);
        if (!((EntityPlayerBridge)player).bridge$shouldRestoreInventory()) {
            return entityItem;
        }
        if (entityItem == null) {
            this.impl$dropCancelled = true;
            PacketPhaseUtil.handleCustomCursor((EntityPlayer)((EntityPlayerMP)player), original);
        }
        return entityItem;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;dropItem(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/EntityItem;", ordinal=1))
    @Nullable
    private EntityItem impl$restoreOnDragSplit(EntityPlayer player, net.minecraft.item.ItemStack itemStackIn, boolean unused) {
        EntityItem entityItem = player.func_71019_a(itemStackIn, unused);
        if (!((EntityPlayerBridge)player).bridge$shouldRestoreInventory()) {
            return entityItem;
        }
        if (entityItem == null) {
            net.minecraft.item.ItemStack original = null;
            if (player.field_71071_by.func_70445_o().func_190926_b()) {
                original = itemStackIn;
            } else {
                player.field_71071_by.func_70445_o().func_190917_f(1);
                original = player.field_71071_by.func_70445_o();
            }
            player.field_71071_by.func_70437_b(original);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, original));
        }
        ((EntityPlayerBridge)player).bridge$shouldRestoreInventory(false);
        return entityItem;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/InventoryPlayer;setItemStack(Lnet/minecraft/item/ItemStack;)V", ordinal=1))
    private void impl$ClearOnSlot(InventoryPlayer inventoryPlayer, net.minecraft.item.ItemStack itemStackIn) {
        if (!this.impl$dropCancelled || !((EntityPlayerBridge)inventoryPlayer.field_70458_d).bridge$shouldRestoreInventory()) {
            inventoryPlayer.func_70437_b(itemStackIn);
        }
        ((EntityPlayerBridge)inventoryPlayer.field_70458_d).bridge$shouldRestoreInventory(false);
        this.impl$dropCancelled = false;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Slot;canTakeStack(Lnet/minecraft/entity/player/EntityPlayer;)Z", ordinal=4))
    public boolean onCanTakeStack(net.minecraft.inventory.Slot slot, EntityPlayer playerIn) {
        boolean result = slot.func_82869_a(playerIn);
        if (result) {
            this.impl$itemStackSnapshot = ItemStackUtil.snapshotOf(slot.func_75211_c());
            this.impl$lastSlotUsed = slot;
        } else {
            this.impl$itemStackSnapshot = ItemStackSnapshot.NONE;
            this.impl$lastSlotUsed = null;
        }
        return result;
    }

    @Nullable
    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;dropItem(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/EntityItem;", ordinal=3))
    private EntityItem onThrowClick(EntityPlayer player, net.minecraft.item.ItemStack itemStackIn, boolean unused) {
        EntityItem entityItem = player.func_71019_a(itemStackIn, true);
        if (entityItem == null && ((EntityPlayerBridge)player).bridge$shouldRestoreInventory()) {
            net.minecraft.item.ItemStack original = ItemStackUtil.toNative(this.impl$itemStackSnapshot.createStack());
            this.impl$lastSlotUsed.func_75215_d(original);
            player.field_71070_bA.func_75142_b();
            ((EntityPlayerMP)player).field_71137_h = false;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(player.field_71070_bA.field_75152_c, this.impl$lastSlotUsed.field_75222_d, original));
        }
        this.impl$itemStackSnapshot = ItemStackSnapshot.NONE;
        this.impl$lastSlotUsed = null;
        ((EntityPlayerBridge)player).bridge$shouldRestoreInventory(false);
        return entityItem;
    }

    @Redirect(method={"slotChangedCraftingGrid"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/InventoryCraftResult;setInventorySlotContents(ILnet/minecraft/item/ItemStack;)V"))
    private void beforeSlotChangedCraftingGrid(InventoryCraftResult output, int index, net.minecraft.item.ItemStack itemstack) {
        if (!this.impl$captureInventory) {
            output.func_70299_a(index, itemstack);
            return;
        }
        ItemStackSnapshot orig = ItemStackUtil.snapshotOf(output.func_70301_a(index));
        output.func_70299_a(index, itemstack);
        ItemStackSnapshot repl = ItemStackUtil.snapshotOf(output.func_70301_a(index));
        SlotAdapter slot = this.impl$getAdapters().get(index);
        this.impl$capturedCraftPreviewTransactions.add(new SlotTransaction(slot, orig, repl));
    }

    @Inject(method={"slotChangedCraftingGrid"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/network/NetHandlerPlayServer;sendPacket(Lnet/minecraft/network/Packet;)V")})
    private void afterSlotChangedCraftingGrid(net.minecraft.world.World world, EntityPlayer player, InventoryCrafting craftingInventory, InventoryCraftResult output, CallbackInfo ci) {
        if (this.impl$firePreview && !this.impl$capturedCraftPreviewTransactions.isEmpty()) {
            Object inv = ((CarriedInventory)((Object)this)).query(QueryOperationTypes.INVENTORY_TYPE.of(CraftingInventory.class));
            if (!(inv instanceof CraftingInventory)) {
                SpongeImpl.getLogger().warn("Detected crafting but Sponge could not get a CraftingInventory for " + this.getClass().getName());
                return;
            }
            SlotTransaction previewTransaction = this.impl$capturedCraftPreviewTransactions.get(this.impl$capturedCraftPreviewTransactions.size() - 1);
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)craftingInventory, (net.minecraft.world.World)world);
            SpongeCommonEventFactory.callCraftEventPre(player, (CraftingInventory)inv, previewTransaction, (CraftingRecipe)recipe, (net.minecraft.inventory.Container)this, this.impl$capturedCraftPreviewTransactions);
            this.impl$capturedCraftPreviewTransactions.clear();
        }
    }

    @Override
    public net.minecraft.item.ItemStack bridge$getPreviousCursor() {
        return this.impl$previousCursor;
    }

    @Inject(method={"slotClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;grow(I)V", ordinal=1)})
    private void beforeOnTakeClickWithItem(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player, CallbackInfoReturnable<Integer> cir) {
        this.impl$previousCursor = player.field_71071_by.func_70445_o().func_77946_l();
    }

    @Inject(method={"slotClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/InventoryPlayer;setItemStack(Lnet/minecraft/item/ItemStack;)V", ordinal=3)})
    private void beforeOnTakeClick(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player, CallbackInfoReturnable<Integer> cir) {
        this.impl$previousCursor = player.field_71071_by.func_70445_o().func_77946_l();
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Slot;onTake(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", ordinal=5))
    private net.minecraft.item.ItemStack redirectOnTakeThrow(net.minecraft.inventory.Slot slot, EntityPlayer player, net.minecraft.item.ItemStack stackOnCursor) {
        this.impl$lastCraft = null;
        net.minecraft.item.ItemStack result = slot.func_190901_a(player, stackOnCursor);
        if (this.impl$lastCraft != null && slot instanceof SlotCrafting && this.impl$lastCraft.isCancelled()) {
            stackOnCursor.func_190920_e(0);
        }
        return result;
    }

    @Inject(method={"slotClick"}, at={@At(value="RETURN")})
    private void onReturn(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player, CallbackInfoReturnable<net.minecraft.item.ItemStack> cir) {
        this.impl$lastCraft = null;
        this.impl$previousCursor = null;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Container;transferStackInSlot(Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;"))
    private net.minecraft.item.ItemStack redirectTransferStackInSlot(net.minecraft.inventory.Container thisContainer, EntityPlayer player, int slotId) {
        net.minecraft.inventory.Slot slot = thisContainer.func_75139_a(slotId);
        if (!(slot instanceof SlotCrafting)) {
            return thisContainer.func_82846_b(player, slotId);
        }
        this.impl$lastCraft = null;
        this.impl$shiftCraft = true;
        net.minecraft.item.ItemStack result = thisContainer.func_82846_b(player, slotId);
        if (this.impl$lastCraft != null && this.impl$lastCraft.isCancelled()) {
            result = net.minecraft.item.ItemStack.field_190927_a;
        }
        this.impl$shiftCraft = false;
        return result;
    }

    @Override
    public boolean bridge$capturingInventory() {
        return this.impl$captureInventory;
    }

    @Override
    public void bridge$setCaptureInventory(boolean flag) {
        this.impl$captureInventory = flag;
    }

    @Override
    public void bridge$setSpectatorChest(boolean spectatorChest) {
        this.impl$spectatorChest = spectatorChest;
    }

    @Override
    public List<SlotTransaction> bridge$getCapturedSlotTransactions() {
        return this.impl$capturedSlotTransactions;
    }

    @Override
    public List<SlotTransaction> bridge$getPreviewTransactions() {
        return this.impl$capturedCraftPreviewTransactions;
    }

    @Override
    public void bridge$setLastCraft(CraftItemEvent.Craft event) {
        this.impl$lastCraft = event;
    }

    @Override
    public void bridge$setFirePreview(boolean firePreview) {
        this.impl$firePreview = firePreview;
    }

    @Override
    public void bridge$setShiftCrafting(boolean flag) {
        this.impl$shiftCraft = flag;
    }

    @Override
    public boolean bridge$isShiftCrafting() {
        return this.impl$shiftCraft;
    }

    @Override
    public void bridge$setCanInteractWith(@Nullable Predicate<EntityPlayer> predicate) {
        this.impl$canInteractWithPredicate = predicate;
    }

    @Override
    public Slot bridge$getContainerSlot(int slot) {
        Slot adapter = this.impl$getAdapters().get(slot);
        if (adapter == null) {
            if (slot >= this.field_75151_b.size()) {
                SpongeImpl.getLogger().warn("Could not find slot #{} in Container {}", (Object)slot, (Object)this.getClass().getName());
                return null;
            }
            net.minecraft.inventory.Slot mcSlot = this.field_75151_b.get(slot);
            if (mcSlot == null) {
                SpongeImpl.getLogger().warn("Could not find slot #{} in Container {}", (Object)slot, (Object)this.getClass().getName());
                return null;
            }
            return (Slot)mcSlot;
        }
        return adapter;
    }

    @Override
    public Location<World> bridge$getOpenLocation() {
        return this.impl$lastOpenLocation;
    }

    @Override
    public void bridge$setOpenLocation(Location<World> loc) {
        this.impl$lastOpenLocation = loc;
    }

    @Override
    public void bridge$setInUse(boolean inUse) {
        this.impl$inUse = inUse;
    }

    @Override
    public boolean bridge$isInUse() {
        return this.impl$inUse;
    }
}

