/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.chunk;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.EntityUniverse;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.util.CacheKeyBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.BlockTransaction;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.gen.WorldGenConstants;

@NonnullByDefault
@Mixin(value={net.minecraft.world.chunk.Chunk.class})
public abstract class ChunkMixin
implements ChunkBridge,
CacheKeyBridge {
    @Shadow
    @Final
    private net.minecraft.world.World field_76637_e;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    @Final
    private int[] field_76638_b;
    @Shadow
    @Final
    private int[] field_76634_f;
    @Shadow
    @Final
    private ClassInheritanceMultiMap<net.minecraft.entity.Entity>[] field_76645_j;
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> field_150816_i;
    @Shadow
    private boolean field_76636_d;
    @Shadow
    private boolean field_76643_l;
    @Shadow
    public boolean field_189550_d;
    private long impl$scheduledForUnload = -1L;
    private boolean impl$persistedChunk = false;
    private boolean impl$isSpawning = false;
    private final net.minecraft.world.chunk.Chunk[] impl$neighbors = new net.minecraft.world.chunk.Chunk[4];
    private long impl$cacheKey;

    @Shadow
    @Nullable
    public abstract TileEntity func_177424_a(BlockPos var1, Chunk.EnumCreateEntityType var2);

    @Shadow
    public abstract void func_76603_b();

    @Shadow
    public abstract int func_177413_a(EnumSkyBlock var1, BlockPos var2);

    @Shadow
    public abstract IBlockState func_177435_g(BlockPos var1);

    @Shadow
    public abstract IBlockState func_186032_a(int var1, int var2, int var3);

    @Shadow
    public abstract Biome func_177411_a(BlockPos var1, BiomeProvider var2);

    @Shadow
    private void func_76595_e(int x, int z) {
    }

    @Shadow
    private void func_76615_h(int x, int y, int z) {
    }

    @Shadow
    protected abstract void func_186034_a(IChunkGenerator var1);

    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")})
    private void impl$onConstruct(net.minecraft.world.World worldIn, int x, int z, CallbackInfo ci) {
        this.impl$cacheKey = ChunkPos.func_77272_a((int)x, (int)z);
    }

    @Override
    public net.minecraft.world.chunk.Chunk[] bridge$getNeighborArray() {
        return Arrays.copyOf(this.impl$neighbors, this.impl$neighbors.length);
    }

    @Override
    public void bridge$markChunkDirty() {
        this.field_76643_l = true;
    }

    @Override
    public boolean bridge$isQueuedForUnload() {
        return this.field_189550_d;
    }

    @Override
    public boolean bridge$isPersistedChunk() {
        return this.impl$persistedChunk;
    }

    @Override
    public void bridge$setPersistedChunk(boolean flag) {
        this.impl$persistedChunk = flag;
        for (TileEntity tileEntity : this.field_150816_i.values()) {
            ((ActiveChunkReferantBridge)tileEntity).bridge$setActiveChunk(this);
        }
        for (ClassInheritanceMultiMap<net.minecraft.entity.Entity> entityList : this.field_76645_j) {
            for (net.minecraft.entity.Entity entity : entityList) {
                ((ActiveChunkReferantBridge)entity).bridge$setActiveChunk(this);
            }
        }
    }

    @Override
    public boolean bridge$isSpawning() {
        return this.impl$isSpawning;
    }

    @Override
    public void bridge$setIsSpawning(boolean spawning) {
        this.impl$isSpawning = spawning;
    }

    @Inject(method={"addEntity"}, at={@At(value="RETURN")})
    private void impl$SetActiveChunkOnEntityAdd(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)entityIn).bridge$setActiveChunk(this);
    }

    @Inject(method={"addTileEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;validate()V")})
    private void impl$SetActiveChunkOnTileEntityAdd(BlockPos pos, TileEntity tileEntityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(this);
        ((OwnershipTrackedBridge)tileEntityIn).tracked$setTrackedUUID(PlayerTracker.Type.NOTIFIER, this.bridge$getBlockNotifierUUID(pos).orElse(null));
        ((OwnershipTrackedBridge)tileEntityIn).tracked$setTrackedUUID(PlayerTracker.Type.OWNER, this.bridge$getBlockOwnerUUID(pos).orElse(null));
    }

    @Inject(method={"removeEntityAtIndex"}, at={@At(value="RETURN")})
    private void impl$ResetEntityActiveChunk(net.minecraft.entity.Entity entityIn, int index, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)entityIn).bridge$setActiveChunk(null);
    }

    @Redirect(method={"removeTileEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;invalidate()V"))
    private void impl$resetTileEntityActiveChunk(TileEntity tileEntityIn) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(null);
        tileEntityIn.func_145843_s();
    }

    @Inject(method={"onLoad"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreOnLoadDuringRegeneration(CallbackInfo ci) {
        if (!this.field_76637_e.field_72995_K && PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
            ci.cancel();
        }
    }

    @Inject(method={"onLoad"}, at={@At(value="RETURN")})
    private void impl$UpdateNeighborsOnLoad(CallbackInfo ci) {
        for (Direction direction : Constants.Chunk.CARDINAL_DIRECTIONS) {
            Vector3i neighborPosition = ((Chunk)((Object)this)).getPosition().add(direction.asBlockOffset());
            ChunkProviderBridge spongeChunkProvider = (ChunkProviderBridge)this.field_76637_e.func_72863_F();
            net.minecraft.world.chunk.Chunk neighbor = spongeChunkProvider.bridge$getLoadedChunkWithoutMarkingActive(neighborPosition.getX(), neighborPosition.getZ());
            if (neighbor == null) continue;
            int neighborIndex = SpongeImpl.directionToIndex(direction);
            int oppositeNeighborIndex = SpongeImpl.directionToIndex(direction.getOpposite());
            this.bridge$setNeighborChunk(neighborIndex, neighbor);
            ((ChunkBridge)neighbor).bridge$setNeighborChunk(oppositeNeighborIndex, (net.minecraft.world.chunk.Chunk)this);
        }
        if (ShouldFire.LOAD_CHUNK_EVENT) {
            SpongeImpl.postEvent(SpongeEventFactory.createLoadChunkEvent(Sponge.getCauseStackManager().getCurrentCause(), (Chunk)((Object)this)));
        }
        if (!this.field_76637_e.field_72995_K) {
            SpongeHooks.logChunkLoad(this.field_76637_e, ((Chunk)((Object)this)).getPosition());
        }
    }

    @Inject(method={"onUnload"}, at={@At(value="RETURN")})
    private void impl$UpdateNeighborsOnUnload(CallbackInfo ci) {
        for (Direction direction : Constants.Chunk.CARDINAL_DIRECTIONS) {
            Vector3i neighborPosition = ((Chunk)((Object)this)).getPosition().add(direction.asBlockOffset());
            ChunkProviderBridge spongeChunkProvider = (ChunkProviderBridge)this.field_76637_e.func_72863_F();
            net.minecraft.world.chunk.Chunk neighbor = spongeChunkProvider.bridge$getLoadedChunkWithoutMarkingActive(neighborPosition.getX(), neighborPosition.getZ());
            if (neighbor == null) continue;
            int neighborIndex = SpongeImpl.directionToIndex(direction);
            int oppositeNeighborIndex = SpongeImpl.directionToIndex(direction.getOpposite());
            this.bridge$setNeighborChunk(neighborIndex, null);
            ((ChunkBridge)neighbor).bridge$setNeighborChunk(oppositeNeighborIndex, null);
        }
        if (!this.field_76637_e.field_72995_K) {
            SpongeImpl.postEvent(SpongeEventFactory.createUnloadChunkEvent(Sponge.getCauseStackManager().getCurrentCause(), (Chunk)((Object)this)));
            SpongeHooks.logChunkUnload(this.field_76637_e, ((Chunk)((Object)this)).getPosition());
        }
    }

    @Inject(method={"getEntitiesWithinAABBForEntity"}, at={@At(value="RETURN")})
    private void impl$ThrowCollisionEvent(net.minecraft.entity.Entity entityIn, AxisAlignedBB aabb, List<net.minecraft.entity.Entity> listToFill, com.google.common.base.Predicate<net.minecraft.entity.Entity> p_177414_4_, CallbackInfo ci) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake() || PhaseTracker.getInstance().getCurrentState().ignoresEntityCollisions()) {
            return;
        }
        if (listToFill.isEmpty()) {
            return;
        }
        if (!ShouldFire.COLLIDE_ENTITY_EVENT) {
            return;
        }
        CollideEntityEvent event = SpongeCommonEventFactory.callCollideEntityEvent(this.field_76637_e, entityIn, listToFill);
        if (event == null || event.isCancelled()) {
            if (event == null && !PhaseTracker.getInstance().getCurrentState().isTicking()) {
                return;
            }
            listToFill.clear();
        }
    }

    @Inject(method={"getEntitiesOfTypeWithinAABB"}, at={@At(value="RETURN")})
    private void impl$throwCollsionEvent(Class<? extends net.minecraft.entity.Entity> entityClass, AxisAlignedBB aabb, List<net.minecraft.entity.Entity> listToFill, com.google.common.base.Predicate<net.minecraft.entity.Entity> p_177430_4_, CallbackInfo ci) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake() || PhaseTracker.getInstance().getCurrentState().ignoresEntityCollisions()) {
            return;
        }
        if (listToFill.isEmpty()) {
            return;
        }
        CollideEntityEvent event = SpongeCommonEventFactory.callCollideEntityEvent(this.field_76637_e, null, listToFill);
        if (event == null || event.isCancelled()) {
            if (event == null && !PhaseTracker.getInstance().getCurrentState().isTicking()) {
                return;
            }
            listToFill.clear();
        }
    }

    @Nullable
    @Overwrite
    public IBlockState func_177436_a(BlockPos pos, IBlockState state) {
        IBlockState iblockstate1 = this.func_177435_g(pos);
        return this.bridge$setBlockState(pos, state, iblockstate1, BlockChangeFlags.ALL);
    }

    @Override
    @Nullable
    public IBlockState bridge$setBlockState(BlockPos pos, IBlockState newState, IBlockState currentState, BlockChangeFlag flag) {
        IBlockState blockAfterSet;
        BlockTransaction.ChangeBlock transaction;
        boolean requiresNewLightCalculations;
        int zPos;
        int combinedPos;
        int xPos = pos.func_177958_n() & 0xF;
        int yPos = pos.func_177956_o();
        if (yPos >= this.field_76638_b[combinedPos = (zPos = pos.func_177952_p() & 0xF) << 4 | xPos] - 1) {
            this.field_76638_b[combinedPos] = -999;
        }
        int currentHeight = this.field_76634_f[combinedPos];
        Block newBlock = newState.func_177230_c();
        Block currentBlock = currentState.func_177230_c();
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[yPos >> 4];
        int newBlockLightOpacity = SpongeImplHooks.getBlockLightOpacity(newState, (IBlockAccess)this.field_76637_e, pos);
        if (extendedblockstorage == net.minecraft.world.chunk.Chunk.field_186036_a) {
            if (newBlock == Blocks.field_150350_a) {
                return null;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(yPos >> 4 << 4, this.field_76637_e.field_73011_w.func_191066_m());
            this.field_76652_q[yPos >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            requiresNewLightCalculations = yPos >= currentHeight;
        } else {
            requiresNewLightCalculations = false;
        }
        boolean isFake = ((WorldBridge)this.field_76637_e).bridge$isFake();
        TileEntity existing = this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        PhaseContext<?> peek = isFake ? null : PhaseTracker.getInstance().getCurrentContext();
        IPhaseState state = isFake ? null : peek.state;
        SpongeBlockSnapshot snapshot = isFake || !ShouldFire.CHANGE_BLOCK_EVENT || !state.shouldCaptureBlockChangeOrSkip(peek, pos, currentState, newState, flag) ? null : this.createSpongeBlockSnapshot(currentState, currentState, pos, flag, existing);
        WorldServerBridge mixinWorld = isFake ? null : (WorldServerBridge)this.field_76637_e;
        int modifiedY = yPos & 0xF;
        extendedblockstorage.func_177484_a(xPos, modifiedY, zPos, newState);
        if (!this.field_76637_e.field_72995_K) {
            if (!isFake && ShouldFire.CHANGE_BLOCK_EVENT && snapshot != null) {
                snapshot.blockChange = peek.state.associateBlockChangeWithSnapshot(peek, newState, newBlock, currentState, snapshot, currentBlock);
                transaction = state.captureBlockChange(peek, pos, snapshot, newState, flag, existing);
                if (currentBlock != newBlock) {
                    if (transaction != null) {
                        transaction.queueBreak = true;
                        transaction.enqueueChanges(mixinWorld.bridge$getProxyAccess(), peek.getCapturedBlockSupplier());
                    }
                    currentBlock.func_180663_b(this.field_76637_e, pos, currentState);
                }
                if (existing != null && SpongeImplHooks.shouldRefresh(existing, this.field_76637_e, pos, currentState, newState)) {
                    if (transaction != null) {
                        ((TileEntityBridge)existing).bridge$setCaptured(true);
                        transaction.queuedRemoval = existing;
                        transaction.enqueueChanges(mixinWorld.bridge$getProxyAccess(), peek.getCapturedBlockSupplier());
                    } else {
                        this.field_76637_e.func_175713_t(pos);
                    }
                }
            } else {
                transaction = null;
                if (!(currentBlock == newBlock || state != null && state.isRestoring())) {
                    currentBlock.func_180663_b(this.field_76637_e, pos, currentState);
                }
                if (existing != null && SpongeImplHooks.shouldRefresh(existing, this.field_76637_e, pos, currentState, newState)) {
                    this.field_76637_e.func_175713_t(pos);
                }
            }
        } else {
            TileEntity tileEntity;
            transaction = null;
            if (SpongeImplHooks.hasBlockTileEntity(currentBlock, currentState) && (tileEntity = this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && SpongeImplHooks.shouldRefresh(tileEntity, this.field_76637_e, pos, currentState, newState)) {
                this.field_76637_e.func_175713_t(pos);
            }
        }
        if ((blockAfterSet = extendedblockstorage.func_177485_a(xPos, modifiedY, zPos)).func_177230_c() != newBlock) {
            if (!isFake && snapshot != null) {
                if (state.doesBulkBlockCapture(peek)) {
                    peek.getCapturedBlockSupplier().prune(snapshot);
                } else {
                    peek.setSingleSnapshot(null);
                }
            }
            return null;
        }
        if (requiresNewLightCalculations) {
            this.func_76603_b();
        } else {
            int postNewBlockLightOpacity = SpongeImplHooks.getBlockLightOpacity(newState, (IBlockAccess)this.field_76637_e, pos);
            if (newBlockLightOpacity > 0) {
                if (yPos >= currentHeight) {
                    this.func_76615_h(xPos, yPos + 1, zPos);
                }
            } else if (yPos == currentHeight - 1) {
                this.func_76615_h(xPos, yPos, zPos);
            }
            if (newBlockLightOpacity != postNewBlockLightOpacity && (newBlockLightOpacity < postNewBlockLightOpacity || this.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || this.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0)) {
                this.func_76595_e(xPos, zPos);
            }
        }
        if (!isFake && currentState != newState) {
            ((WorldServerBridge)this.field_76637_e).bridge$getProxyAccess().onChunkChanged(pos, newState);
        }
        if (!isFake && currentBlock != newBlock) {
            boolean isBulkCapturing;
            boolean bl = isBulkCapturing = ShouldFire.CHANGE_BLOCK_EVENT && state.doesBulkBlockCapture(peek);
            if (flag.performBlockPhysics()) {
                if (transaction != null) {
                    transaction.queueOnAdd = true;
                } else if (!isBulkCapturing || SpongeImplHooks.hasBlockTileEntity(newBlock, newState)) {
                    newBlock.func_176213_c(this.field_76637_e, pos, newState);
                }
            }
        }
        if (SpongeImplHooks.hasBlockTileEntity(newBlock, newState)) {
            TileEntity tileentity = this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity == null) {
                User owner;
                tileentity = SpongeImplHooks.createTileEntity(newBlock, this.field_76637_e, newState);
                if (!isFake && (owner = (User)peek.getOwner().orElse(null)) != null) {
                    this.bridge$addTrackedBlockPosition(newBlock, pos, owner, PlayerTracker.Type.OWNER);
                }
                if (transaction != null) {
                    transaction.queueTileSet = tileentity;
                    if (tileentity != null) {
                        ((TileEntityBridge)tileentity).bridge$setCaptured(true);
                        tileentity.func_145834_a(this.field_76637_e);
                        tileentity.func_174878_a(pos);
                    }
                    transaction.enqueueChanges(mixinWorld.bridge$getProxyAccess(), peek.getCapturedBlockSupplier());
                } else {
                    if (tileentity != null && tileentity.func_145831_w() != this.field_76637_e) {
                        tileentity.func_145834_a(this.field_76637_e);
                    }
                    this.field_76637_e.func_175690_a(pos, tileentity);
                }
            }
            if (tileentity != null) {
                tileentity.func_145836_u();
            }
        } else if (transaction != null) {
            transaction.enqueueChanges(mixinWorld.bridge$getProxyAccess(), peek.getCapturedBlockSupplier());
        }
        this.field_76643_l = true;
        return currentState;
    }

    @Override
    public void bridge$removeTileEntity(TileEntity removed) {
        TileEntity tileentity = this.field_150816_i.remove(removed.func_174877_v());
        if (tileentity != removed && tileentity != null) {
            this.field_150816_i.put(removed.func_174877_v(), tileentity);
        }
        ((ActiveChunkReferantBridge)removed).bridge$setActiveChunk(null);
        removed.func_145843_s();
    }

    @Override
    public void bridge$setTileEntity(BlockPos pos, TileEntity added) {
        if (added.func_145831_w() != this.field_76637_e) {
            added.func_145834_a(this.field_76637_e);
        }
        added.func_174878_a(pos);
        if (this.field_150816_i.containsKey(pos)) {
            this.field_150816_i.get(pos).func_145843_s();
        }
        added.func_145829_t();
        ((ActiveChunkReferantBridge)added).bridge$setActiveChunk(this);
        this.field_150816_i.put(pos, added);
    }

    private SpongeBlockSnapshot createSpongeBlockSnapshot(IBlockState state, IBlockState extended, BlockPos pos, BlockChangeFlag updateFlag, @Nullable TileEntity existing) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.reset();
        builder.blockState(state).extendedState(extended).worldId(((World)this.field_76637_e).getUniqueId()).position(VecHelper.toVector3i(pos));
        Optional<UUID> creator = this.bridge$getBlockOwnerUUID(pos);
        Optional<UUID> notifier = this.bridge$getBlockNotifierUUID(pos);
        creator.ifPresent(builder::creator);
        notifier.ifPresent(builder::notifier);
        if (existing != null) {
            TrackingUtil.addTileEntityToBuilder(existing, builder);
        }
        builder.flag(updateFlag);
        return builder.build();
    }

    @Override
    public void bridge$addTrackedBlockPosition(Block block, BlockPos pos, User user, PlayerTracker.Type trackerType) {
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return Collections.emptyMap();
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return Collections.emptyMap();
    }

    @Override
    public Optional<User> bridge$getBlockOwner(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockOwnerUUID(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<User> bridge$getBlockNotifier(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public void bridge$setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
    }

    @Override
    public void bridge$setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
    }

    @Redirect(method={"populate(Lnet/minecraft/world/chunk/IChunkProvider;Lnet/minecraft/world/gen/IChunkGenerator;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/IChunkProvider;getLoadedChunk(II)Lnet/minecraft/world/chunk/Chunk;"))
    private net.minecraft.world.chunk.Chunk impl$GetChunkWithoutMarkingAsActive(IChunkProvider chunkProvider, int x, int z) {
        return ((ChunkProviderBridge)chunkProvider).bridge$getLoadedChunkWithoutMarkingActive(x, z);
    }

    @Inject(method={"populate(Lnet/minecraft/world/gen/IChunkGenerator;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/gen/IChunkGenerator;populate(II)V")})
    private void impl$StartTerrainGenerationState(IChunkGenerator generator, CallbackInfo callbackInfo) {
        if (!this.field_76637_e.field_72995_K && !PhaseTracker.getInstance().getCurrentState().isRegeneration()) {
            ((GenericGenerationContext)GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext().world(this.field_76637_e)).buildAndSwitch();
        }
    }

    @Inject(method={"populate(Lnet/minecraft/world/gen/IChunkGenerator;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;markDirty()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/gen/IChunkGenerator;populate(II)V"))})
    private void impl$CloseTerrainGenerationState(IChunkGenerator generator, CallbackInfo info) {
        if (!this.field_76637_e.field_72995_K && !PhaseTracker.getInstance().getCurrentState().isRegeneration()) {
            PhaseTracker.getInstance().getCurrentContext().close();
        }
    }

    @Override
    public void bridge$setNeighborChunk(int index, @Nullable net.minecraft.world.chunk.Chunk chunk) {
        this.impl$neighbors[index] = chunk;
    }

    @Override
    @Nullable
    public net.minecraft.world.chunk.Chunk bridge$getNeighborChunk(int index) {
        return this.impl$neighbors[index];
    }

    @Override
    public List<net.minecraft.world.chunk.Chunk> bridge$getNeighbors() {
        ArrayList<net.minecraft.world.chunk.Chunk> neighborList = new ArrayList<net.minecraft.world.chunk.Chunk>();
        for (net.minecraft.world.chunk.Chunk neighbor : this.impl$neighbors) {
            if (neighbor == null) continue;
            neighborList.add(neighbor);
        }
        return neighborList;
    }

    @Override
    public boolean bridge$areNeighborsLoaded() {
        for (int i = 0; i < 4; ++i) {
            if (this.impl$neighbors[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void bridge$setNeighbor(Direction direction, @Nullable net.minecraft.world.chunk.Chunk neighbor) {
        this.impl$neighbors[SpongeImpl.directionToIndex((Direction)direction)] = neighbor;
    }

    @Override
    public long bridge$getScheduledForUnload() {
        return this.impl$scheduledForUnload;
    }

    @Override
    public void bridge$setScheduledForUnload(long scheduled) {
        this.impl$scheduledForUnload = scheduled;
    }

    @Override
    public void bridge$getIntersectingEntities(Vector3d start, Vector3d direction, double distance, Predicate<? super EntityUniverse.EntityHit> filter, double entryY, double exitY, Set<? super EntityUniverse.EntityHit> intersections) {
        double yMin = Math.min(entryY, exitY);
        double yMax = Math.max(entryY, exitY);
        int lowestSubChunk = GenericMath.clamp(GenericMath.floor((yMin - 2.0) / 16.0), 0, this.field_76645_j.length - 1);
        int highestSubChunk = GenericMath.clamp(GenericMath.floor((yMax + 2.0) / 16.0), 0, this.field_76645_j.length - 1);
        for (int i = lowestSubChunk; i <= highestSubChunk; ++i) {
            this.impl$getIntersectingEntities((Collection<? extends net.minecraft.entity.Entity>)this.field_76645_j[i], start, direction, distance, filter, intersections);
        }
    }

    private void impl$getIntersectingEntities(Collection<? extends net.minecraft.entity.Entity> entities, Vector3d start, Vector3d direction, double distance, Predicate<? super EntityUniverse.EntityHit> filter, Set<? super EntityUniverse.EntityHit> intersections) {
        for (net.minecraft.entity.Entity entity : entities) {
            EntityUniverse.EntityHit hit;
            Tuple<Vector3d, Vector3d> intersection;
            double distanceSquared;
            Optional<Tuple<Vector3d, Vector3d>> optionalIntersection;
            Entity spongeEntity = (Entity)entity;
            Optional<AABB> box = spongeEntity.getBoundingBox();
            if (!box.isPresent() || !(optionalIntersection = box.get().intersects(start, direction)).isPresent() || (distanceSquared = (intersection = optionalIntersection.get()).getFirst().sub(start).lengthSquared()) > distance * distance || !filter.test(hit = new EntityUniverse.EntityHit(spongeEntity, intersection.getFirst(), intersection.getSecond(), Math.sqrt(distanceSquared)))) continue;
            intersections.add(hit);
            net.minecraft.entity.Entity[] parts = entity.func_70021_al();
            if (parts == null || parts.length <= 0) continue;
            this.impl$getIntersectingEntities(Arrays.asList(parts), start, direction, distance, filter, intersections);
        }
    }

    @Inject(method={"generateSkylightMap"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IfLightingEnabledCancel(CallbackInfo ci) {
        if (!WorldGenConstants.lightingEnabled) {
            ci.cancel();
        }
    }

    @Override
    public void bridge$fill(ChunkPrimer primer) {
        boolean flag = this.field_76637_e.field_73011_w.func_191066_m();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    IBlockState block = primer.func_177856_a(x, y, z);
                    if (block.func_185904_a() == Material.field_151579_a) continue;
                    int section = y >> 4;
                    if (this.field_76652_q[section] == net.minecraft.world.chunk.Chunk.field_186036_a) {
                        this.field_76652_q[section] = new ExtendedBlockStorage(section << 4, flag);
                    }
                    this.field_76652_q[section].func_177484_a(x, y & 0xF, z, block);
                }
            }
        }
    }

    @Redirect(method={"addTileEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;invalidate()V"))
    private void redirectInvalidate(TileEntity te) {
        SpongeImplHooks.onTileEntityInvalidate(te);
    }

    @Override
    public boolean bridge$isActive() {
        if (this.bridge$isPersistedChunk()) {
            return true;
        }
        return this.field_76636_d && !this.bridge$isQueuedForUnload() && this.bridge$getScheduledForUnload() == -1L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("World", (Object)this.field_76637_e).add("Position", this.field_76635_g + this.field_76647_h).toString();
    }

    @Override
    public long bridge$getCacheKey() {
        return this.impl$cacheKey;
    }
}

