/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.invaders;

import java.util.Random;
import net.minecraft.init.SoundEvents;
import vswe.stevescarts.arcade.ArcadeGame;
import vswe.stevescarts.arcade.invaders.ArcadeInvaders;
import vswe.stevescarts.arcade.invaders.Projectile;
import vswe.stevescarts.arcade.invaders.Unit;
import vswe.stevescarts.guis.GuiMinecart;

public class InvaderGhast
extends Unit {
    private int tentacleTextureId;
    private int shooting;
    protected boolean isPahighast;
    private boolean hasTarget;
    private int targetX;
    private int targetY;

    public InvaderGhast(ArcadeInvaders game, int x, int y) {
        super(game, x, y);
        this.tentacleTextureId = game.getModule().getCart().random.nextInt(4);
        this.shooting = -10;
        if (game.canSpawnPahighast && !game.hasPahighast && game.getModule().getCart().random.nextInt(1000) == 0) {
            this.isPahighast = true;
            game.hasPahighast = true;
        }
    }

    @Override
    public void draw(GuiMinecart gui) {
        if (this.isPahighast) {
            this.game.drawImageInArea(gui, this.x, this.y, 32, 32, 16, 16);
        } else {
            this.game.drawImageInArea(gui, this.x, this.y, this.shooting > -10 ? 16 : 0, 0, 16, 16);
        }
        this.game.drawImageInArea(gui, this.x, this.y + 16, 0, 16 + 8 * this.tentacleTextureId, 16, 8);
    }

    @Override
    public Unit.UPDATE_RESULT update() {
        if (this.hasTarget) {
            boolean flag = false;
            if (this.x != this.targetX) {
                this.x = this.x > this.targetX ? Math.max(this.targetX, this.x - 4) : Math.min(this.targetX, this.x + 4);
                flag = true;
            }
            if (this.y != this.targetY) {
                this.y = this.y > this.targetY ? Math.max(this.targetY, this.y - 4) : Math.min(this.targetY, this.y + 4);
                flag = true;
            }
            return flag ? Unit.UPDATE_RESULT.TARGET : Unit.UPDATE_RESULT.DONE;
        }
        if (super.update() == Unit.UPDATE_RESULT.DEAD) {
            return Unit.UPDATE_RESULT.DEAD;
        }
        if (this.shooting > -10) {
            if (this.shooting == 0) {
                Random random = this.game.getModule().getCart().random;
                ArcadeGame.playSound(SoundEvents.field_187557_bK, 0.1f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                this.game.projectiles.add(new Projectile(this.game, this.x + 8 - 3, this.y + 8 - 3, false));
            }
            --this.shooting;
        }
        if (this.game.moveDown > 0) {
            ++this.y;
        } else {
            this.x += this.game.moveDirection * this.game.moveSpeed;
            if (this.y > 130) {
                return Unit.UPDATE_RESULT.GAME_OVER;
            }
            if (this.x > 417 || this.x < 10) {
                return Unit.UPDATE_RESULT.TURN_BACK;
            }
        }
        if (!this.isPahighast && this.shooting == -10 && this.game.getModule().getCart().random.nextInt(300) == 0) {
            this.shooting = 10;
        }
        return Unit.UPDATE_RESULT.DONE;
    }

    @Override
    protected int getHitboxWidth() {
        return 16;
    }

    @Override
    protected int getHitboxHeight() {
        return 24;
    }

    public void setTarget(int x, int y) {
        this.hasTarget = true;
        this.targetX = x;
        this.targetY = y;
    }
}

