/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.item;

import java.util.List;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IMergedBlock;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.block.MalisisBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MalisisItemBlock
extends ItemBlock
implements IRegisterable<Item>,
IComponentProvider {
    public MalisisItemBlock(MalisisBlock block) {
        super((Block)block);
        this.setName(block.getName().toString());
    }

    private MalisisBlock block() {
        return (MalisisBlock)this.field_150939_a;
    }

    @Override
    public void addComponent(IComponent component) {
        this.block().addComponent(component);
    }

    @Override
    public List<IComponent> getComponents() {
        return this.block().getComponents();
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.block().getTranslationKey(this.block().getStateFromItemStack(itemStack));
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos.func_177972_a(side), side, itemStack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState placedState = this.checkMerge(itemStack, player, world, pos, side, hitX, hitY, hitZ);
        BlockPos p = pos;
        if (placedState == null) {
            p = pos.func_177972_a(side);
            float x = hitX - (float)side.func_82601_c();
            float y = hitY - (float)side.func_96559_d();
            float z = hitZ - (float)side.func_82599_e();
            placedState = this.checkMerge(itemStack, player, world, p, side, x, y, z);
        }
        if (placedState == null) {
            return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        Block block = placedState.func_177230_c();
        if (world.func_72855_b(placedState.func_185890_d((IBlockAccess)world, p)) && world.func_180501_a(p, placedState, 3)) {
            SoundType soundType = block.getSoundType(placedState, world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            itemStack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack itemStack) {
        IMergedBlock mergedBlock = this.getMerged(world.func_180495_p(pos));
        if (mergedBlock != null && mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return true;
        }
        mergedBlock = this.getMerged(world.func_180495_p(pos = pos.func_177972_a(side)));
        if (mergedBlock != null && mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return true;
        }
        return super.func_179222_a(world, pos, side, player, itemStack);
    }

    private IMergedBlock getMerged(IBlockState state) {
        IMergedBlock mergedBlock = IComponent.getComponent(IMergedBlock.class, state.func_177230_c());
        if (mergedBlock == null) {
            return null;
        }
        if (mergedBlock.mergeSelfOnly() && state.func_177230_c() != this.block()) {
            return null;
        }
        return mergedBlock;
    }

    private IBlockState checkMerge(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        IMergedBlock mergedBlock = this.getMerged(state);
        if (mergedBlock == null || !mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return null;
        }
        return mergedBlock.mergeBlock(world, pos, state, itemStack, player, side, hitX, hitY, hitZ);
    }

    public boolean func_77614_k() {
        return this.field_150939_a instanceof MalisisBlock ? ((MalisisBlock)this.field_150939_a).hasItemSubtypes((Item)this) : false;
    }
}

