/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class ColorTransform
extends Transformation<ColorTransform, ITransformable.Color> {
    protected int fromColor;
    protected int toColor;

    public ColorTransform(int fromColor, int toColor) {
        this.fromColor = fromColor;
        this.toColor = toColor;
    }

    @Override
    public ColorTransform self() {
        return this;
    }

    public ColorTransform from(int color) {
        this.fromColor = color;
        return this;
    }

    public ColorTransform to(int color) {
        this.toColor = color;
        return this;
    }

    private int red(int color) {
        return color >> 16 & 0xFF;
    }

    private int green(int color) {
        return color >> 8 & 0xFF;
    }

    private int blue(int color) {
        return color & 0xFF;
    }

    @Override
    protected void doTransform(ITransformable.Color transformable, float comp) {
        if (comp <= 0.0f) {
            return;
        }
        int from = this.reversed ? this.toColor : this.fromColor;
        int to = this.reversed ? this.fromColor : this.toColor;
        int r = (int)((float)this.red(from) + (float)(this.red(to) - this.red(from)) * comp);
        int g = (int)((float)this.green(from) + (float)(this.green(to) - this.green(from)) * comp);
        int b = (int)((float)this.blue(from) + (float)(this.blue(to) - this.blue(from)) * comp);
        transformable.setColor((r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }
}

