/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.event;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

public class FoamEvent
extends WorldEvent {
    final BlockPos pos;

    public FoamEvent(World world, BlockPos pos) {
        super(world);
        this.pos = pos;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IBlockState getBlockState() {
        return this.getWorld().func_180495_p(this.getPos());
    }

    public Block getBlock() {
        return this.getBlockState().func_177230_c();
    }

    public TileEntity getTileEntity() {
        return this.getWorld().func_175625_s(this.getPos());
    }

    public static enum FoamResult {
        Any,
        Scaffold,
        Cable,
        Custom;

    }

    @Cancelable
    public static class Place
    extends FoamEvent {
        boolean placeFoam = false;

        public Place(World world, BlockPos pos) {
            super(world, pos);
        }

        public void requestFoamPlacement() {
            this.placeFoam = true;
        }

        public boolean hasFoamPlaceRequest() {
            return this.placeFoam;
        }
    }

    @Cancelable
    public static class Check
    extends FoamEvent {
        FoamResult foamResult = FoamResult.Any;
        boolean hasCustomTarget;

        public Check(World world, BlockPos pos) {
            super(world, pos);
        }

        public void setResult(FoamResult result) {
            this.foamResult = result;
            this.hasCustomTarget = true;
        }

        public FoamResult getFoamResult() {
            return this.hasCustomTarget ? this.foamResult : FoamResult.Any;
        }

        public void setHasTarget(boolean par1) {
            this.hasCustomTarget = par1;
        }

        public boolean hasCustomTarget() {
            return this.hasCustomTarget;
        }
    }
}

