/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.block.crop.crops.CropSeedDropBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropPumpkin
extends CropSeedDropBase {
    public CropPumpkin() {
        super(new CropProperties(1, 0, 1, 0, 3, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        return this.getSprite("bc")[15 + state];
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Orange", "Decoration", "Stem"};
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public String getId() {
        return "Pumpkin";
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() <= 3;
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        return (int)((float)humidity * 1.1f + (float)nutrients * 0.9f + (float)air);
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Blocks.field_150423_aK);
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return new ItemStack(Items.field_151080_bb);
    }

    @Override
    public ItemStack getSeeds(ICropTile crop) {
        if (crop.getStatGain() <= 1 && crop.getStatGrowth() <= 1 && crop.getStatResistance() <= 1) {
            return new ItemStack(Items.field_151080_bb, IC2.random.nextInt(3) + 1);
        }
        return super.getSeeds(crop);
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 600;
        }
        return 200;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 3;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }
}

