/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc;

import ic2.core.IC2;
import ic2.core.block.render.model.DynamiteModel;
import ic2.core.entity.explosion.EntityDynamite;
import ic2.core.entity.explosion.EntityITNT;
import ic2.core.entity.explosion.EntityNuke;
import ic2.core.entity.explosion.IExplodableEntity;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBlockStateLoader;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockExplosive
extends Block
implements IBootable,
IBlockStateLoader,
ITexturedBlock,
ICustomModeledBlock,
ILocaleBlock {
    public static List<EnumFacing> indexList = Arrays.asList(EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST);
    public static PropertyInteger types = PropertyInteger.func_177719_a((String)"blocktype", (int)0, (int)3);
    public static PropertyDirection dynamiteFacing = PropertyDirection.func_177713_a((String)"facing", indexList);
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB((double)0.4f, 0.0, (double)0.4f, (double)0.6f, (double)0.6f, (double)0.6f);
    protected static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, (double)0.7f, (double)0.65f, (double)0.8f, 1.0);
    protected static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, 0.0, (double)0.65f, (double)0.8f, (double)0.3f);
    protected static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB((double)0.7f, (double)0.2f, (double)0.35f, 1.0, (double)0.8f, (double)0.65f);
    protected static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.35f, (double)0.3f, (double)0.8f, (double)0.65f);

    public BlockExplosive() {
        super(Material.field_151590_u);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)types, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)dynamiteFacing, (Comparable)EnumFacing.DOWN));
        this.func_149672_a(SoundType.field_185850_c);
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.explosive;
    }

    @Deprecated
    public int func_149717_k(IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)types) > 1) {
            return 0;
        }
        return super.func_149717_k(state);
    }

    @Override
    public List<IBlockState> getValidStates(IBlockState defaultState) {
        this.func_180632_j(defaultState.func_177226_a((IProperty)types, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)dynamiteFacing, (Comparable)EnumFacing.DOWN));
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (int i = 0; i < 12; ++i) {
            states.add(this.func_176203_a(i));
        }
        return states;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{types, dynamiteFacing});
    }

    @Override
    public void onLoad() {
        Ic2Items.industrialTNT = new ItemStack((Block)this, 1, 0);
        Ic2Items.nuke = new ItemStack((Block)this, 1, 1);
        Ic2States.industrialTNT = this.func_176203_a(0);
        Ic2States.nuke = this.func_176203_a(1);
        Ic2States.dynamite = this.func_176203_a(2);
        Ic2States.dynamiteWithRemote = this.func_176203_a(7);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < 2; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)types) < 2;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)types) < 2;
    }

    @Deprecated
    public boolean func_149721_r(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)types) < 2;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)types) < 2;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Integer)base_state.func_177229_b((IProperty)types) < 2;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.func_176201_c(state) < 2) {
            return field_185505_j;
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)dynamiteFacing)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        if (this.func_176201_c(blockState) < 2) {
            return field_185505_j;
        }
        return field_185506_k;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P();
        }
        if (meta == 1) {
            return this.func_176223_P().func_177226_a((IProperty)types, (Comparable)Integer.valueOf(1));
        }
        if (meta >= 2 && meta <= 6) {
            return this.func_176223_P().func_177226_a((IProperty)types, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)dynamiteFacing, (Comparable)indexList.get(meta - 2));
        }
        if (meta >= 7 && meta <= 11) {
            return this.func_176223_P().func_177226_a((IProperty)types, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)dynamiteFacing, (Comparable)indexList.get(meta - 7));
        }
        return super.func_176203_a(meta);
    }

    public int func_176201_c(IBlockState state) {
        int type = (Integer)state.func_177229_b((IProperty)types);
        if (type < 2) {
            return type;
        }
        if (type == 2) {
            return 2 + indexList.indexOf(state.func_177229_b((IProperty)dynamiteFacing));
        }
        if (type == 3) {
            return 7 + indexList.indexOf(state.func_177229_b((IProperty)dynamiteFacing));
        }
        return 0;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (meta > 1) {
            IBlockState result = Blocks.field_150350_a.func_176223_P();
            if (facing != EnumFacing.DOWN && world.func_175677_d(pos.func_177972_a(facing.func_176734_d()), false)) {
                result = this.func_176203_a(meta).func_177226_a((IProperty)dynamiteFacing, (Comparable)(facing == EnumFacing.UP ? facing.func_176734_d() : facing));
            }
            return result;
        }
        if (meta == 1 && placer instanceof EntityPlayer) {
            IC2.log.info("Player " + ((EntityPlayer)placer).func_146103_bH().getName() + " placed a nuke at " + world.field_73011_w.getDimension() + ":(" + pos.toString() + ")");
        }
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing facing : indexList) {
            if (!worldIn.func_175677_d(facing.func_176740_k().func_176720_b() ? pos.func_177972_a(facing) : pos.func_177972_a(facing.func_176734_d()), false)) continue;
            return true;
        }
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (worldIn.func_175640_z(pos) && this.getExplosionEntity(state, worldIn, pos, null, ActivationType.BlockUpdate) != null) {
            this.explode(worldIn, pos, state, null, ActivationType.BlockUpdate);
            return;
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        Entity explosion = this.getExplosionEntity(worldIn.func_180495_p(pos), worldIn, pos, null, ActivationType.Explosion);
        if (explosion != null) {
            IExplodableEntity entity;
            if (explosion instanceof IExplodableEntity && (entity = (IExplodableEntity)explosion).canRandomTime()) {
                int time = entity.getFuseTime();
                entity.setFuseTime(worldIn.field_73012_v.nextInt(time / 4) + time / 8);
            }
            worldIn.func_72838_d(explosion);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing facing;
        if (worldIn.func_175640_z(pos) && this.getExplosionEntity(state, worldIn, pos, null, ActivationType.BlockUpdate) != null) {
            this.explode(worldIn, pos, state, null, ActivationType.BlockUpdate);
            return;
        }
        if ((Integer)state.func_177229_b((IProperty)types) > 1 && this.dropIfCantStay(worldIn, pos) && !worldIn.func_175677_d((facing = (EnumFacing)state.func_177229_b((IProperty)dynamiteFacing)).func_176740_k().func_176720_b() ? pos.func_177972_a(facing) : pos.func_177972_a(facing.func_176734_d()), false)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if ((Integer)state.func_177229_b((IProperty)types) > 1) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(Ic2Items.dynamite.func_77946_l());
            return list;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public boolean dropIfCantStay(World world, BlockPos pos) {
        if (!this.func_176196_c(world, pos)) {
            this.func_180652_a(world, pos, null);
            world.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public void explode(World world, BlockPos pos, IBlockState state, EntityPlayer player, ActivationType type) {
        this.onIgnite(world, pos, player, state);
        world.func_72838_d(this.getExplosionEntity(state, world, pos, player, ActivationType.Player));
        world.func_184133_a(player, pos, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        world.func_175698_g(pos);
    }

    public Entity getExplosionEntity(IBlockState state, World world, BlockPos pos, EntityPlayer player, ActivationType type) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return new EntityITNT(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
        if (meta == 1) {
            if (type == ActivationType.Explosion) {
                return null;
            }
            return new EntityNuke(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).setIgniter(player);
        }
        int time = type == ActivationType.Explosion ? 5 : 40;
        EntityDynamite dynamite = new EntityDynamite(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        dynamite.fuse = time;
        return dynamite;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        this.func_180652_a(world, pos, explosion);
        world.func_175698_g(pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.field_151033_d || heldItem.func_77973_b() == Items.field_151059_bz) {
            if (worldIn.field_72995_K) {
                return true;
            }
            this.onIgnite(worldIn, pos, playerIn, state);
            worldIn.func_72838_d(this.getExplosionEntity(state, worldIn, pos, playerIn, ActivationType.Player));
            worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_175698_g(pos);
            if (heldItem.func_77973_b() == Items.field_151033_d) {
                heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
            } else if (!playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public void onIgnite(World world, BlockPos pos, EntityPlayer player, IBlockState state) {
        if (this.func_176201_c(state) == 1) {
            IC2.log.info("Nuke at " + world.field_73011_w.getDimension() + ":(" + pos.toString() + ") was ignited " + (player == null ? "indirectly" : "by " + player.func_146103_bH().getName()));
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing par1) {
        TextureAtlasSprite[] array = Ic2Icons.getTextures("b0");
        int type = (Integer)state.func_177229_b((IProperty)types);
        if (par1 == EnumFacing.DOWN) {
            return array[58];
        }
        if (par1 == EnumFacing.UP) {
            return array[59];
        }
        if (type == 0) {
            return array[60];
        }
        if (type == 1) {
            return array[63];
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)types) == 0 ? Ic2Icons.getTextures("b0")[60] : Ic2Icons.getTextures("b0")[63];
    }

    @Override
    public List<IBlockState> getValidStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        states.add(this.func_176203_a(0));
        states.add(this.func_176203_a(1));
        return states;
    }

    @Override
    public List<IBlockState> getValidModelStates() {
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        for (int meta : Arrays.asList(2, 3, 4, 5, 6, 7, 8, 9, 10, 11)) {
            list.add(this.func_176203_a(meta));
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromState(IBlockState state) {
        return new DynamiteModel(Ic2Icons.getTextures("b0")[(Integer)state.func_177229_b((IProperty)types) == 2 ? 57 : 56], (EnumFacing)state.func_177229_b((IProperty)dynamiteFacing));
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta < 2) {
            return this.func_176203_a(meta);
        }
        return null;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        int type = (Integer)state.func_177229_b((IProperty)types);
        if (type > 1) {
            return layer == BlockRenderLayer.CUTOUT;
        }
        return layer == BlockRenderLayer.SOLID;
    }

    public static enum ActivationType {
        BlockUpdate,
        Explosion,
        Player;

    }
}

