/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.render;

import com.google.common.math.DoubleMath;
import ic2.api.classic.energy.render.IRenderEntry;
import ic2.core.energy.render.PathComponent;
import java.math.RoundingMode;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class RenderEntry
implements IRenderEntry {
    double posX;
    double posY;
    double posZ;
    double nextX;
    double nextY;
    double nextZ;
    double speed = 0.2;
    double totalLoss;
    double progress;
    EnumFacing lastDirection = EnumFacing.NORTH;
    boolean valid = true;
    boolean teleport = false;
    PathComponent myComponent;
    EnumFacing.AxisDirection[] movements = new EnumFacing.AxisDirection[]{EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE};

    private RenderEntry() {
    }

    public RenderEntry(PathComponent component) {
        this.myComponent = component;
        BlockPos pos = this.myComponent.getPosition();
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        this.totalLoss = component.getLoss();
    }

    public void setNext(PathComponent next) {
        this.myComponent = next;
        BlockPos goal = this.myComponent.getPosition();
        this.nextX = goal.func_177958_n();
        this.nextY = goal.func_177956_o();
        this.nextZ = goal.func_177952_p();
        double distance = Math.abs(Math.sqrt(goal.func_177954_c(this.posX, this.posY, this.posZ)));
        this.teleport = distance >= 3.0;
        this.progress = distance;
        this.totalLoss += next.getLoss();
    }

    public RenderEntry copy() {
        RenderEntry entry = new RenderEntry();
        entry.posX = this.posX;
        entry.posY = this.posY;
        entry.posZ = this.posZ;
        entry.myComponent = this.myComponent;
        entry.totalLoss = this.totalLoss;
        entry.speed = this.speed;
        entry.lastDirection = entry.lastDirection;
        entry.movements[0] = this.movements[0];
        entry.movements[1] = this.movements[1];
        entry.movements[2] = this.movements[2];
        return entry;
    }

    public void setSpeed(double newSpeed) {
        this.speed = newSpeed;
        if (newSpeed < 0.001) {
            this.speed = 0.001;
        }
    }

    public void onTick() {
        if (this.teleport) {
            this.teleport = false;
            this.posX = this.nextX;
            this.posY = this.nextY;
            this.posZ = this.nextZ;
            return;
        }
        if (this.posX < this.nextX) {
            this.posX += this.speed;
            this.progress -= this.speed;
            this.movements[0] = EnumFacing.AxisDirection.POSITIVE;
            this.lastDirection = EnumFacing.EAST;
        } else if (this.posX > this.nextX) {
            this.posX -= this.speed;
            this.progress -= this.speed;
            this.movements[0] = EnumFacing.AxisDirection.NEGATIVE;
            this.lastDirection = EnumFacing.WEST;
        }
        if (this.posY < this.nextY) {
            this.posY += this.speed;
            this.progress -= this.speed;
            this.movements[1] = EnumFacing.AxisDirection.POSITIVE;
            this.lastDirection = EnumFacing.UP;
        } else if (this.posY > this.nextY) {
            this.posY -= this.speed;
            this.progress -= this.speed;
            this.movements[1] = EnumFacing.AxisDirection.NEGATIVE;
            this.lastDirection = EnumFacing.DOWN;
        }
        if (this.posZ < this.nextZ) {
            this.posZ += this.speed;
            this.progress -= this.speed;
            this.movements[2] = EnumFacing.AxisDirection.POSITIVE;
            this.lastDirection = EnumFacing.SOUTH;
        } else if (this.posZ > this.nextZ) {
            this.posZ -= this.speed;
            this.progress -= this.speed;
            this.movements[2] = EnumFacing.AxisDirection.NEGATIVE;
            this.lastDirection = EnumFacing.NORTH;
        }
    }

    private EnumFacing fromPositions(double x, double x2, double y, double y2, double z, double z2) {
        if (x < x2) {
            return EnumFacing.EAST;
        }
        if (x > x2) {
            return EnumFacing.WEST;
        }
        if (y < y2) {
            return EnumFacing.UP;
        }
        if (y > y2) {
            return EnumFacing.DOWN;
        }
        if (z < z2) {
            return EnumFacing.SOUTH;
        }
        if (z > z2) {
            return EnumFacing.NORTH;
        }
        return null;
    }

    public PathComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public Vec3d getPosition() {
        return new Vec3d(this.posX, this.posY, this.posZ);
    }

    public AxisAlignedBB getBox() {
        return new AxisAlignedBB(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).func_186662_g(-0.01);
    }

    public boolean hasReached() {
        boolean reached;
        boolean bl = reached = DoubleMath.roundToInt((double)this.progress, (RoundingMode)RoundingMode.CEILING) <= 0;
        if (reached) {
            this.posX = this.nextX;
            this.posY = this.nextY;
            this.posZ = this.nextZ;
        }
        return reached;
    }

    public EnumFacing getDirection() {
        return this.lastDirection;
    }

    public double getLoss() {
        return this.totalLoss;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }
}

