/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric.scanners;

import ic2.core.IC2;
import ic2.core.item.tool.electric.scanners.IScanner;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuarryScanner
implements IScanner {
    @Override
    public boolean isAdv(ItemStack stack) {
        return true;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state) {
        return state.func_177230_c() != Blocks.field_150350_a ? 1 : 0;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            return 0;
        }
        return 1;
    }

    @Override
    public Set<IBlockState> getTargets(ItemStack stack) {
        return EMPTY_STATES;
    }

    @Override
    public int getRadius(ItemStack stack) {
        if (this.isUpgraded(stack)) {
            return StackUtil.getNbtData(stack).func_74762_e("UpgradedRadius");
        }
        return 12;
    }

    @Override
    public int getCost(ItemStack stack) {
        return 25;
    }

    @Override
    public boolean isValue(ItemStack stack) {
        return false;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isFluidScanner(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isFluidValid(ItemStack stack, FluidStack fluid) {
        return false;
    }

    @Override
    public Set<Fluid> getFluidTargets(ItemStack stack) {
        return EMPTY_FLUIDS;
    }

    @Override
    public LocaleComp getName(ItemStack stack) {
        return Ic2ItemLang.scannerQuarry;
    }

    @Override
    public boolean hasCustomInfo(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addCustomInfo(ItemStack stack, EntityPlayer player, List<String> list, List<String> post, Map<ToolTipType, List<String>> sortedTip) {
        post.add(Ic2InfoLang.scannerAll.getLocalized());
        if (this.isUpgraded(stack)) {
            List<String> ctrlTip = sortedTip.get((Object)ToolTipType.Ctrl);
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2InfoLang.ScannerIncreaseRadius.getLocalized());
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(9), Ic2InfoLang.ScannerDecreaseRadius));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(0), Ic2InfoLang.ScannerRadiusEffect));
        }
        return false;
    }

    @Override
    public boolean showTargets(ItemStack stack) {
        return false;
    }

    @Override
    public boolean hasRightClick(ItemStack stack) {
        return this.isUpgraded(stack);
    }

    @Override
    public boolean onRightClick(ItemStack stack, EntityPlayer player, EnumHand hand, World world) {
        int effect;
        int n = effect = player.func_70093_af() ? -1 : 1;
        if (IC2.keyboard.isAltKeyDown(player)) {
            effect *= 10;
        }
        int result = MathHelper.func_76125_a((int)(this.getRadius(stack) + effect), (int)1, (int)30);
        this.setRadius(stack, result);
        IC2.platform.messagePlayer(player, Ic2InfoLang.scannerRange, result);
        return true;
    }

    @Override
    public boolean hasAOE(ItemStack stack) {
        return false;
    }

    public boolean isUpgraded(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("Upgraded");
    }

    public void setRadius(ItemStack stack, int radius) {
        StackUtil.getOrCreateNbtData(stack).func_74768_a("UpgradedRadius", radius);
    }
}

