/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import ic2.core.network.buffers.FieldBuffer;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;

public class FieldUpdatePacket
extends IC2Packet {
    Map<BlockPos, List<NetworkManager.FieldData>> data = new LinkedHashMap<BlockPos, List<NetworkManager.FieldData>>();
    int dimID;

    public FieldUpdatePacket() {
    }

    public FieldUpdatePacket(Map<BlockPos, List<NetworkManager.FieldData>> par1, World par2) {
        this.data = par1;
        this.dimID = par2.field_73011_w.getDimension();
    }

    @Override
    public void read(ByteBuf par1) {
        InputBuffer buffer = new InputBuffer(par1);
        this.dimID = buffer.readInt();
        int length = buffer.readMedium();
        for (int i = 0; i < length; ++i) {
            BlockPos pos = BlockPos.func_177969_a((long)buffer.readLong());
            int expected = buffer.readByte();
            ArrayList<NetworkManager.FieldData> list = new ArrayList<NetworkManager.FieldData>(expected);
            for (int x = 0; x < expected; ++x) {
                byte data = buffer.readByte();
                if (data > 0) {
                    byte index = buffer.readByte();
                    NetworkField.BitLevel level = NetworkField.BitLevel.getLevel(data - 1);
                    list.add(new NetworkManager.FieldData(index, level, DataEncoder.decode(buffer, level)));
                    continue;
                }
                String id = buffer.readString(NetworkField.BitLevel.Bit8);
                list.add(new NetworkManager.FieldData(id, DataEncoder.decode(buffer)));
            }
            this.data.put(pos, list);
        }
    }

    @Override
    public void write(ByteBuf par1) {
        OutputBuffer buffer = new OutputBuffer(par1);
        buffer.writeInt(this.dimID);
        buffer.writeMedium(this.data.size());
        for (Map.Entry<BlockPos, List<NetworkManager.FieldData>> entry : this.data.entrySet()) {
            buffer.writeLong(entry.getKey().func_177986_g());
            List<NetworkManager.FieldData> dataList = entry.getValue();
            buffer.writeByte((byte)dataList.size());
            for (NetworkManager.FieldData data : dataList) {
                if (data.isNew) {
                    buffer.writeByte((byte)(1 + data.bitLevel.getIndex()));
                    buffer.writeByte((byte)data.index);
                    DataEncoder.encode(buffer, data.data, data.bitLevel);
                    continue;
                }
                buffer.writeByte((byte)0);
                buffer.writeString(data.fieldName, NetworkField.BitLevel.Bit8);
                DataEncoder.encode(buffer, data.data);
            }
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Got Incorrect Data");
        }
        for (Map.Entry<BlockPos, List<NetworkManager.FieldData>> entry : this.data.entrySet()) {
            List<NetworkManager.FieldData> list = entry.getValue();
            BlockPos coord = entry.getKey();
            TileEntity tile = world.func_175625_s(coord);
            if (tile == null) continue;
            INetworkUpdateListener listener = tile == null ? null : (INetworkUpdateListener)tile;
            FieldBuffer buffer = NetworkManager.getFieldBuffer(tile);
            for (NetworkManager.FieldData fields : list) {
                FieldBuffer.FieldInfo info;
                FieldBuffer.FieldInfo fieldInfo = info = fields.isNew ? buffer.getInfo(fields.index) : buffer.getInfo(fields.fieldName);
                if (info == null) {
                    FMLLog.getLogger().info("Field: " + (fields.isNew ? Integer.valueOf(fields.index) : fields.fieldName) + ", Not Exsistend In the clientSide");
                    continue;
                }
                try {
                    info.setData(tile, fields.data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                if (listener == null) continue;
                listener.onNetworkUpdate(info.getFieldID());
            }
        }
    }
}

