/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.misc;

import ic2.api.info.IInfoProvider;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.item.misc.ItemFuelCan;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.IFuelHandler;

public class ItemInfo
implements IInfoProvider,
IFuelHandler {
    @Override
    public double getEnergyValue(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == null) {
            return 0.0;
        }
        if (item instanceof IElectricItem) {
            return ElectricItem.manager.getCharge(stack);
        }
        if (item == Ic2Items.suBattery.func_77973_b()) {
            return 1000.0;
        }
        if (item == Items.field_151137_ax) {
            return 500.0;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
            return 4500.0;
        }
        return 0.0;
    }

    @Override
    public int getFuelValue(ItemStack stack, boolean allowLava) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item itemId = stack.func_77973_b();
        FluidStack liquid = FluidUtil.getFluidContained((ItemStack)stack);
        if (liquid != null && liquid.getFluid() == FluidRegistry.LAVA) {
            if (allowLava) {
                return 2000;
            }
            return 0;
        }
        if (StackUtil.isStackEqual(stack, Ic2Items.scrap) && !IC2.config.getFlag("BurningScrap")) {
            return 0;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public int getBurnTime(ItemStack fuel) {
        ItemFuelCan can;
        if (fuel.func_190926_b()) {
            return 0;
        }
        if (StackUtil.isStackEqual(fuel, Ic2Items.rubberSapling)) {
            return 80;
        }
        if (StackUtil.isStackEqual(fuel, Ic2Items.scrap)) {
            return 350;
        }
        if (StackUtil.isStackEqual(fuel, Ic2Items.lavaCell)) {
            return TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151129_at));
        }
        Item item = fuel.func_77973_b();
        if (item == Items.field_151120_aE || item == Item.func_150898_a((Block)Blocks.field_150434_aF)) {
            return 50;
        }
        if (item instanceof ItemFuelCan && (can = (ItemFuelCan)item).hasFuel(fuel)) {
            return can.drainFuel(fuel, false);
        }
        if (StackUtil.isStackEqual(fuel, Ic2Items.charcoalBlock)) {
            return 16000;
        }
        return 0;
    }
}

