/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui;

import com.direwolf20.buildinggadgets.client.gui.ActionPressed;
import com.direwolf20.buildinggadgets.client.proxy.ClientProxy;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.Collection;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiSliderInt
extends GuiSlider {
    private int colorBackground;
    private int colorSliderBackground;
    private int colorSlider;
    private BiConsumer<GuiSliderInt, Integer> increment;
    private int value;

    public GuiSliderInt(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Color color, GuiSlider.ISlider par, BiConsumer<GuiSliderInt, Integer> increment) {
        super(0, xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, par);
        this.colorBackground = ClientProxy.getColor(color, 200).getRGB();
        this.colorSliderBackground = ClientProxy.getColor(color.darker(), 200).getRGB();
        this.colorSlider = ClientProxy.getColor(color.brighter().brighter(), 200).getRGB();
        this.increment = increment;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        this.setValue(this.getValueInt());
    }

    public void updateSlider() {
        super.updateSlider();
        int valueInt = this.getValueInt();
        if (this.value != valueInt) {
            this.value = valueInt;
            this.playSound();
        }
    }

    private void playSound() {
        ClientProxy.playSound(SoundEvents.field_187576_at, 2.0f);
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
        if (!this.field_146125_m) {
            return;
        }
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        GuiSliderInt.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)this.colorBackground);
        this.func_146119_b(mc, mouseX, mouseY);
        this.renderText(mc, (GuiButton)this);
    }

    private void renderText(Minecraft mc, GuiButton component) {
        int color = !this.field_146124_l ? 0xA0A0A0 : (this.field_146123_n ? 0xFFFFA0 : -1);
        String buttonText = component.field_146126_j;
        int strWidth = mc.field_71466_p.func_78256_a(buttonText);
        int ellipsisWidth = mc.field_71466_p.func_78256_a("...");
        if (strWidth > component.field_146120_f - 6 && strWidth > ellipsisWidth) {
            buttonText = mc.field_71466_p.func_78269_a(buttonText, component.field_146120_f - 6 - ellipsisWidth).trim() + "...";
        }
        this.func_73732_a(mc.field_71466_p, buttonText, component.field_146128_h + component.field_146120_f / 2, component.field_146129_i + (component.field_146121_g - 8) / 2, color);
    }

    public void func_146113_a(SoundHandler soundHandlerIn) {
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (!this.field_146125_m) {
            return;
        }
        if (this.dragging) {
            this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            this.updateSlider();
        }
        this.drawBorderedRect(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)), this.field_146129_i, 8, this.field_146121_g);
    }

    private void drawBorderedRect(int x, int y, int width, int height) {
        GuiSliderInt.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)this.colorSliderBackground);
        GuiSliderInt.func_73734_a((int)(++x), (int)(++y), (int)(x + width - 2), (int)(y + height - 2), (int)this.colorSlider);
    }

    public Collection<GuiButton> getComponents() {
        return ImmutableSet.of((Object)((Object)this), (Object)((Object)new GuiButtonIncrement(this, this.field_146128_h - this.field_146121_g, this.field_146129_i, this.field_146121_g, this.field_146121_g, "-", () -> this.increment.accept(this, -1))), (Object)((Object)new GuiButtonIncrement(this, this.field_146128_h + this.field_146120_f, this.field_146129_i, this.field_146121_g, this.field_146121_g, "+", () -> this.increment.accept(this, 1))));
    }

    private static class GuiButtonIncrement
    extends GuiButton {
        private GuiSliderInt parent;
        private ActionPressed action;

        public GuiButtonIncrement(GuiSliderInt parent, int x, int y, int width, int height, String buttonText, Runnable action) {
            super(0, x, y, width, height, buttonText);
            this.parent = parent;
            this.action = new ActionPressed(action);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
            if (!this.field_146125_m) {
                return;
            }
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            GuiButtonIncrement.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)this.parent.colorBackground);
            this.parent.drawBorderedRect(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
            this.parent.renderText(mc, this);
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.action.pressed(super.func_146116_c(mc, mouseX, mouseY));
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
        }
    }
}

