/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.vc.EntityMagicProjectile;
import noppes.vc.EntityProjectile;
import noppes.vc.VCItems;
import noppes.vc.VCTabs;
import noppes.vc.VCWeapons;
import noppes.vc.VariedCommodities;
import noppes.vc.client.VCSounds;
import noppes.vc.enchants.VCEnchant;
import noppes.vc.items.ItemBasic;
import noppes.vc.items.VCToolMaterial;

public class ItemStaff
extends ItemBasic {
    private VCToolMaterial material;

    public ItemStaff(VCToolMaterial material) {
        this.material = material;
        this.func_77637_a(VCTabs.WEAPONS);
        this.func_77664_n();
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() == ItemStaff.this ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public void func_77615_a(final ItemStack stack, World worldObj, EntityLivingBase entity, int par4) {
        if (worldObj.field_72995_K) {
            return;
        }
        if (stack.func_77978_p() == null) {
            return;
        }
        Entity proj = ((WorldServer)worldObj).func_73045_a(stack.func_77978_p().func_74762_e("MagicProjectile"));
        if (proj == null || !(proj instanceof EntityProjectile)) {
            return;
        }
        EntityProjectile item = (EntityProjectile)proj;
        item.callback = new EntityProjectile.IProjectileCallback(){

            @Override
            public boolean onImpact(EntityProjectile entityProjectile, BlockPos pos, Entity entity) {
                int poison;
                if (entity == null || !(entity instanceof EntityLivingBase)) {
                    return false;
                }
                EntityLivingBase living = (EntityLivingBase)entity;
                int confusion = VCEnchant.getLevel(VCEnchant.Confusion, stack);
                if (confusion > 0 && living.func_70681_au().nextInt(4) < confusion) {
                    living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100));
                }
                if ((poison = VCEnchant.getLevel(VCEnchant.Poison, stack)) > 0 && living.func_70681_au().nextInt(4) < poison) {
                    living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
                }
                return false;
            }
        };
        item.explosiveDamage = false;
        item.explosiveRadius = 1;
        item.field_70126_B = item.field_70177_z = entity.field_70177_z;
        item.field_70127_C = item.field_70125_A = entity.field_70125_A;
        item.shoot(2.0f);
        ItemStaff.playSound(entity, VCSounds.MAGIC_SHOT, 1.0f, 1.0f);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int count) {
        double dz;
        double dx;
        int tick = this.func_77626_a(stack) - count;
        if (entity.field_70170_p.field_72995_K) {
            this.spawnParticle(stack, entity);
            return;
        }
        int chargeTime = 20 + this.material.getHarvestLevel() * 8;
        if (tick == chargeTime) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!player.field_71075_bZ.field_75098_d && !this.hasInfinite(stack)) {
                    if (!this.hasItem(player, VCWeapons.mana)) {
                        return;
                    }
                    this.consumeItem(player, VCWeapons.mana);
                }
            }
            ItemStaff.playSound(entity, VCSounds.MAGIC_CHARGE, 1.0f, 1.0f);
            int damage = 6 + this.material.getDamageVsEntity() + entity.field_70170_p.field_73012_v.nextInt(4);
            damage = (int)((float)damage + (float)(damage * VCEnchant.getLevel(VCEnchant.Damage, stack)) * 0.5f);
            EntityMagicProjectile projectile = new EntityMagicProjectile(entity.field_70170_p, entity, this.getProjectile(stack));
            projectile.damage = damage;
            projectile.setSpeed(25);
            dx = -MathHelper.func_76126_a((float)((float)((double)(entity.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(entity.field_70125_A / 180.0f) * Math.PI)));
            dz = MathHelper.func_76134_b((float)((float)((double)(entity.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(entity.field_70125_A / 180.0f) * Math.PI)));
            projectile.func_70107_b(entity.field_70165_t + dx * 0.8, entity.field_70163_u + 1.5 - (double)(entity.field_70125_A / 80.0f), entity.field_70161_v + dz * 0.8);
            entity.field_70170_p.func_72838_d((Entity)projectile);
            stack.func_77983_a("MagicProjectile", (NBTBase)new NBTTagInt(projectile.func_145782_y()));
        }
        if (tick > chargeTime && stack.func_77978_p() != null) {
            Entity proj = ((WorldServer)entity.field_70170_p).func_73045_a(stack.func_77978_p().func_74762_e("MagicProjectile"));
            if (proj == null || !(proj instanceof EntityProjectile)) {
                return;
            }
            EntityProjectile item = (EntityProjectile)proj;
            item.field_70195_i = 0;
            dx = -MathHelper.func_76126_a((float)((float)((double)(entity.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(entity.field_70125_A / 180.0f) * Math.PI)));
            dz = MathHelper.func_76134_b((float)((float)((double)(entity.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(entity.field_70125_A / 180.0f) * Math.PI)));
            item.func_70107_b(entity.field_70165_t + dx * 0.8, entity.field_70163_u + 1.5 - (double)(entity.field_70125_A / 80.0f), entity.field_70161_v + dz * 0.8);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public ItemStack getProjectile(ItemStack stack) {
        if (stack.func_77973_b() == VCWeapons.wooden_staff) {
            return new ItemStack(VCItems.spell_nature);
        }
        if (stack.func_77973_b() == VCWeapons.stone_staff || stack.func_77973_b() == VCWeapons.demonic_staff) {
            return new ItemStack(VCItems.spell_dark);
        }
        if (stack.func_77973_b() == VCWeapons.iron_staff || stack.func_77973_b() == VCWeapons.mithril_staff) {
            return new ItemStack(VCItems.spell_holy);
        }
        if (stack.func_77973_b() == VCWeapons.bronze_staff) {
            return new ItemStack(VCItems.spell_lightning);
        }
        if (stack.func_77973_b() == VCWeapons.golden_staff) {
            return new ItemStack(VCItems.spell_fire);
        }
        if (stack.func_77973_b() == VCWeapons.diamond_staff || stack.func_77973_b() == VCWeapons.frost_staff) {
            return new ItemStack(VCItems.spell_ice);
        }
        if (stack.func_77973_b() == VCWeapons.emerald_staff) {
            return new ItemStack(VCItems.spell_arcane);
        }
        return new ItemStack(VCItems.orb, 1, stack.func_77952_i());
    }

    public void spawnParticle(ItemStack stack, EntityLivingBase entity) {
        if (stack.func_77973_b() == VCWeapons.wooden_staff) {
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 5, 2);
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 12, 2);
        } else if (stack.func_77973_b() == VCWeapons.stone_staff || stack.func_77973_b() == VCWeapons.demonic_staff) {
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 5649239, 2);
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 4400964, 2);
        } else if (stack.func_77973_b() == VCWeapons.bronze_staff) {
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 8648694, 2);
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 6091007, 2);
        } else if (stack.func_77973_b() == VCWeapons.iron_staff || stack.func_77973_b() == VCWeapons.mithril_staff) {
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 0xFCFFC9, 2);
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 15728535, 2);
        } else if (stack.func_77973_b() == VCWeapons.golden_staff) {
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 1, 2);
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 14, 2);
        } else if (stack.func_77973_b() == VCWeapons.diamond_staff || stack.func_77973_b() == VCWeapons.frost_staff) {
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 9756653, 2);
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 4503295, 2);
        } else if (stack.func_77973_b() == VCWeapons.emerald_staff) {
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 16761831, 2);
            VariedCommodities.proxy.spawnParticle(entity, "Spell", 16487167, 2);
        }
    }

    public int func_77619_b() {
        return this.material.getEnchantability();
    }

    public boolean hasInfinite(ItemStack stack) {
        return VCEnchant.getLevel(VCEnchant.Infinite, stack) > 0;
    }
}

