/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import net.minecraft.client.Minecraft;

public class DrawableConcat
implements IDrawable {
    final List<Entry> entryList;

    public DrawableConcat() {
        this(new ArrayList<Entry>());
    }

    public DrawableConcat(List<Entry> entryList) {
        this.entryList = entryList;
    }

    public DrawableConcat add(IDrawable drawable, int x_offset, int y_offset) {
        this.entryList.add(new Entry(drawable, x_offset, y_offset));
        return this;
    }

    public int getWidth() {
        int w = 0;
        for (Entry entry2 : this.entryList) {
            w = Math.max(w, entry2.offset_x + entry2.drawable.getWidth());
        }
        return w;
    }

    public int getHeight() {
        int h = 0;
        for (Entry entry2 : this.entryList) {
            h = Math.max(h, entry2.offset_y + entry2.drawable.getHeight());
        }
        return h;
    }

    public void draw(@Nonnull Minecraft minecraft) {
        this.draw(minecraft, 0, 0);
    }

    public void draw(@Nonnull Minecraft minecraft, int xOffset, int yOffset) {
        for (Entry entry2 : this.entryList) {
            entry2.drawable.draw(minecraft, entry2.offset_x + xOffset, entry2.offset_y + yOffset);
        }
    }

    public static class Entry {
        final IDrawable drawable;
        final int offset_x;
        final int offset_y;

        public Entry(IDrawable drawable, int offset_x, int offset_y) {
            this.drawable = drawable;
            this.offset_x = offset_x;
            this.offset_y = offset_y;
        }
    }
}

