/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.backend.entries.EntryHandler;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.hud.HUDHandler;
import com.rwtema.extrautils2.hud.IHudHandler;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.PacketPowerInfo;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.player.IPlayerPowerCreator;
import com.rwtema.extrautils2.power.player.PlayerPower;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientPower
implements IHudHandler {
    private static final HashSet<Item> powerItems = new HashSet();
    public static HashMap<IPlayerPowerCreator, PlayerPower> powerClient = new HashMap();
    static float powerCreated;
    static float powerDrained;
    public static final PowerManager.IPowerReport POWER_REPORT;
    static BlockPos currentPosition;
    static float currentPositionEnergy;
    static float currentPositionEfficiency;

    public static void init() {
    }

    public static String powerStatusString() {
        return Lang.translatePrefix("Grid Power:") + " " + StringHelper.niceFormat(powerDrained) + " / " + StringHelper.niceFormat(powerCreated);
    }

    public static boolean isPowered() {
        return powerDrained <= powerCreated;
    }

    public static boolean hasNoPower() {
        return powerDrained == 0.0f && powerCreated == 0.0f;
    }

    @Nullable
    public static <T extends Item> PlayerPower getClient(T item) {
        return powerClient.get(item);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void playerPowerManagerTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (ItemStack stack : PlayerHelper.getAllPlayerItems((EntityPlayer)player)) {
            if (!StackHelper.isNonNull(stack) || !(stack.func_77973_b() instanceof IPlayerPowerCreator)) continue;
            IPlayerPowerCreator creator = (IPlayerPowerCreator)stack.func_77973_b();
            PlayerPower playerPower = powerClient.get(creator);
            if (playerPower == null || creator.shouldOverride(playerPower, (EntityPlayer)player, stack, stack == player.field_71071_by.func_70448_g())) {
                playerPower = creator.createPower((EntityPlayer)player, stack);
                powerClient.put(creator, playerPower);
            } else if (!playerPower.shouldSustain(stack)) continue;
            playerPower.cooldown = 2;
        }
        Iterator<Map.Entry<IPlayerPowerCreator, PlayerPower>> iterator = powerClient.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IPlayerPowerCreator, PlayerPower> entry2 = iterator.next();
            PlayerPower playerPower = entry2.getValue();
            --playerPower.cooldown;
            if (playerPower.cooldown < 0) {
                iterator.remove();
                continue;
            }
            playerPower.tickClient();
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            currentPosition = null;
            currentPositionEnergy = Float.NaN;
        } else {
            if (currentPosition != null && !currentPosition.equals((Object)mop.func_178782_a())) {
                currentPositionEnergy = Float.NaN;
            }
            currentPosition = mop.func_178782_a();
            WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
            if (theWorld != null) {
                TileEntity tileEntity = theWorld.func_175625_s(mop.func_178782_a());
                if (tileEntity instanceof IPower) {
                    NetworkHandler.sendPacketToServer(new PacketPowerInfo(currentPositionEnergy, currentPositionEfficiency, currentPosition));
                } else {
                    currentPositionEnergy = Float.NaN;
                    currentPositionEfficiency = 1.0f;
                    currentPosition = null;
                }
            }
        }
    }

    @Override
    public void render(GuiIngameForge hud, ScaledResolution resolution, float partialTicks) {
        boolean flag = currentPosition != null;
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (!flag && thePlayer != null && StackHelper.isNonNull(thePlayer.func_184614_ca()) && powerItems.contains(thePlayer.func_184614_ca().func_77973_b())) {
            flag = true;
        }
        if (!flag) {
            return;
        }
        int y = resolution.func_78328_b() * 7 / 10;
        hud.func_73732_a(hud.func_175179_f(), ClientPower.powerStatusString(), resolution.func_78326_a() / 2, y, -1);
        if (!Float.isNaN(currentPositionEnergy)) {
            y += hud.func_175179_f().field_78288_b + 1;
            if (currentPositionEnergy == 0.0f) {
                String text = Lang.translatePrefix("No Power Used/Generated");
                hud.func_73732_a(hud.func_175179_f(), text, resolution.func_78326_a() / 2, y, -1);
            } else {
                String text = currentPositionEnergy < 0.0f ? Lang.translatePrefix("Power Generating:") + " " + StringHelper.niceFormat(-currentPositionEnergy) : Lang.translatePrefix("Power Drain:") + " " + StringHelper.niceFormat(currentPositionEnergy);
                hud.func_73732_a(hud.func_175179_f(), text, resolution.func_78326_a() / 2, y, -1);
                if (currentPositionEfficiency != 1.0f) {
                    text = Lang.translate("Effective Rate:") + " " + StringHelper.niceFormat(Math.abs(-currentPositionEnergy * currentPositionEfficiency)) + " (" + StringHelper.formatPercent(1.0f - currentPositionEfficiency) + " " + Lang.translate("Power Loss") + ")";
                    hud.func_73732_a(hud.func_175179_f(), text, resolution.func_78326_a() / 2, y += hud.func_175179_f().field_78288_b + 1, -1);
                }
            }
        }
    }

    static {
        POWER_REPORT = new PowerManager.IPowerReport(){

            @Override
            public boolean isPowered() {
                return ClientPower.isPowered();
            }

            @Override
            public float getPowerDrain() {
                return powerDrained;
            }

            @Override
            public float getPowerCreated() {
                return powerCreated;
            }
        };
        currentPositionEfficiency = 1.0f;
        for (Entry entry2 : EntryHandler.entries) {
            if (!(entry2 instanceof BlockEntry) || !entry2.enabled) continue;
            for (Class<? extends TileEntity> clazz : ((BlockEntry)entry2).teClazzes) {
                if (!IPower.class.isAssignableFrom(clazz)) continue;
                powerItems.add((Item)((XUBlock)entry2.value).itemBlock);
            }
        }
        ClientPower handler = new ClientPower();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        HUDHandler.register(handler);
    }
}

