/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.rwtema.extrautils2.compatibility.StackHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public interface GetterSetter<T>
extends Consumer<T>,
Supplier<T> {

    public static class PlayerHand
    implements GetterSetter<ItemStack> {
        final InventoryPlayer inventoryPlayer;

        public PlayerHand(InventoryPlayer inventoryPlayer) {
            this.inventoryPlayer = inventoryPlayer;
        }

        @Override
        public void accept(ItemStack stack) {
            this.inventoryPlayer.func_70437_b(stack);
        }

        @Override
        public ItemStack get() {
            return this.inventoryPlayer.func_70445_o();
        }
    }

    public static class InvSlot
    implements GetterSetter<ItemStack> {
        final IInventory inventory;
        final int slot;

        public InvSlot(IInventory inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
        }

        @Override
        public void accept(ItemStack stack) {
            this.inventory.func_70299_a(this.slot, stack);
        }

        @Override
        public ItemStack get() {
            return this.inventory.func_70301_a(this.slot);
        }
    }

    public static class ContainerSlot
    implements GetterSetter<ItemStack> {
        final Slot slot;

        public ContainerSlot(Slot slot) {
            this.slot = slot;
        }

        @Override
        public void accept(ItemStack stack) {
            this.slot.func_75215_d(stack);
        }

        @Override
        public ItemStack get() {
            return this.slot.func_75216_d() ? this.slot.func_75211_c() : StackHelper.empty();
        }
    }
}

