/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.ChatConfig;
import io.github.aquerr.eaglefactions.api.entities.ChatEnum;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.chat.AllianceMessageChannelImpl;
import io.github.aquerr.eaglefactions.common.messaging.chat.FactionMessageChannelImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.transform.SimpleTextTemplateApplier;
import org.spongepowered.api.util.Tristate;

public class ChatMessageListener
extends AbstractListener {
    private final ChatConfig chatConfig;

    public ChatMessageListener(EagleFactions plugin) {
        super(plugin);
        this.chatConfig = plugin.getConfiguration().getChatConfig();
    }

    @Listener
    @IsCancelled(value=Tristate.FALSE)
    public void onChatMessage(MessageChannelEvent.Chat event, @Root Player player) {
        MessageChannel messageChannel = event.getOriginalChannel();
        MessageEvent.MessageFormatter messageFormatter = event.getFormatter();
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            if (this.chatConfig.shouldSuppressOtherFactionsMessagesWhileInTeamChat()) {
                MessageChannel suppressedChannel = this.hideMessageForPlayersInFactionChat(messageChannel);
                event.setChannel(suppressedChannel);
            }
            if (!this.chatConfig.getNonFactionPlayerPrefix().toPlain().equals("")) {
                messageFormatter.getHeader().insert(0, new SimpleTextTemplateApplier(TextTemplate.of((Object[])new Object[]{Text.of((Object[])new Object[]{this.chatConfig.getFactionStartPrefix(), this.chatConfig.getNonFactionPlayerPrefix(), this.chatConfig.getFactionEndPrefix()})})));
            }
            return;
        }
        Faction playerFaction = optionalPlayerFaction.get();
        Text.Builder formattedMessage = Text.builder();
        Text.Builder factionAndRankPrefix = Text.builder();
        Text.Builder factionPrefix = Text.builder();
        Text.Builder rankPrefix = Text.builder();
        Text.Builder chatTypePrefix = Text.builder();
        Text.Builder message = Text.builder();
        ChatEnum chatType = EagleFactionsPlugin.CHAT_LIST.get(player.getUniqueId());
        if (chatType == null) {
            chatType = ChatEnum.GLOBAL;
        }
        switch (chatType) {
            case FACTION: {
                message.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, messageFormatter.getBody().format()})});
                chatTypePrefix.append(new Text[]{this.getFactionChatPrefix()});
                messageChannel = new FactionMessageChannelImpl(playerFaction);
                MutableMessageChannel channel = messageChannel.asMutable();
                channel.addMember((MessageReceiver)Sponge.getServer().getConsole());
                this.getAdminReceivers().forEach(arg_0 -> ((MutableMessageChannel)channel).addMember(arg_0));
                break;
            }
            case ALLIANCE: {
                message.append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, messageFormatter.getBody().format()})});
                chatTypePrefix.append(new Text[]{this.getAllianceChatPrefix()});
                messageChannel = new AllianceMessageChannelImpl(playerFaction);
                MutableMessageChannel channel = messageChannel.asMutable();
                channel.addMember((MessageReceiver)Sponge.getServer().getConsole());
                this.getAdminReceivers().forEach(arg_0 -> ((MutableMessageChannel)channel).addMember(arg_0));
                break;
            }
            default: {
                message.append(new Text[]{messageFormatter.getBody().format()});
                if (!this.chatConfig.shouldSuppressOtherFactionsMessagesWhileInTeamChat()) break;
                messageChannel = this.hideMessageForPlayersInFactionChat(messageChannel);
            }
        }
        factionPrefix.append(new Text[]{this.getFactionPrefix(playerFaction)});
        if (this.chatConfig.shouldDisplayRank()) {
            rankPrefix.append(new Text[]{this.getRankPrefix(playerFaction, player)});
        }
        if (this.chatConfig.isFactionPrefixFirstInChat()) {
            factionAndRankPrefix.append(new Text[]{factionPrefix.build()});
            factionAndRankPrefix.append(new Text[]{rankPrefix.build()});
        } else {
            factionAndRankPrefix.append(new Text[]{rankPrefix.build()});
            factionAndRankPrefix.append(new Text[]{factionPrefix.build()});
        }
        formattedMessage.append(new Text[]{message.build()});
        messageFormatter.getHeader().insert(0, new SimpleTextTemplateApplier(TextTemplate.of((Object[])new Object[]{factionAndRankPrefix})));
        messageFormatter.getHeader().insert(0, new SimpleTextTemplateApplier(TextTemplate.of((Object[])new Object[]{chatTypePrefix})));
        messageFormatter.setBody((TextRepresentable)formattedMessage);
        event.setChannel(messageChannel);
    }

    private MessageChannel hideMessageForPlayersInFactionChat(MessageChannel messageChannel) {
        Collection chatMembers = messageChannel.getMembers();
        HashSet newReceivers = new HashSet(chatMembers);
        for (MessageReceiver messageReceiver : chatMembers) {
            Player receiver;
            if (!(messageReceiver instanceof Player) || !EagleFactionsPlugin.CHAT_LIST.containsKey((receiver = (Player)messageReceiver).getUniqueId()) || EagleFactionsPlugin.CHAT_LIST.get(receiver.getUniqueId()) == ChatEnum.GLOBAL) continue;
            newReceivers.remove(receiver);
        }
        return MessageChannel.fixed(newReceivers);
    }

    private Text getFactionPrefix(Faction playerFaction) {
        if (this.chatConfig.getChatPrefixType().equals("tag")) {
            if (playerFaction.getTag().toPlain().equals("")) {
                return playerFaction.getTag();
            }
            Text factionTag = playerFaction.getTag();
            if (!this.chatConfig.canColorTags()) {
                factionTag = factionTag.toBuilder().color(TextColors.GREEN).build();
            }
            return Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), factionTag, this.chatConfig.getFactionEndPrefix()}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.BLUE, "Click to view information about the faction!"}))).onClick((ClickAction)TextActions.runCommand((String)("/f info " + playerFaction.getName()))).build();
        }
        if (this.chatConfig.getChatPrefixType().equals("name")) {
            return Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), Text.of((Object[])new Object[]{TextColors.GREEN, playerFaction.getName(), TextColors.RESET}), this.chatConfig.getFactionEndPrefix()}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.BLUE, "Click to view information about the faction!"}))).onClick((ClickAction)TextActions.runCommand((String)("/f info " + playerFaction.getName()))).build();
        }
        return playerFaction.getTag();
    }

    private Text getAllianceChatPrefix() {
        return Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), Text.of((Object[])new Object[]{TextColors.BLUE, Messages.ALLIANCE_CHAT, TextColors.RESET}), this.chatConfig.getFactionEndPrefix()}).build();
    }

    private Text getFactionChatPrefix() {
        return Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), Text.of((Object[])new Object[]{TextColors.GREEN, Messages.FACTION_CHAT, TextColors.RESET}), this.chatConfig.getFactionEndPrefix()}).build();
    }

    private Text getRankPrefix(Faction faction, Player player) {
        if (faction.getLeader().equals(player.getUniqueId())) {
            return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{this.chatConfig.getFactionStartPrefix(), TextColors.GOLD, Messages.LEADER, TextColors.RESET, this.chatConfig.getFactionEndPrefix()})}).build();
        }
        if (faction.getOfficers().contains(player.getUniqueId())) {
            return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{this.chatConfig.getFactionStartPrefix(), TextColors.GOLD, Messages.OFFICER, TextColors.RESET, this.chatConfig.getFactionEndPrefix()})}).build();
        }
        if (faction.getMembers().contains(player.getUniqueId())) {
            return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{this.chatConfig.getFactionStartPrefix(), TextColors.GOLD, Messages.MEMBER, TextColors.RESET, this.chatConfig.getFactionEndPrefix()})}).build();
        }
        return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{this.chatConfig.getFactionStartPrefix(), TextColors.GOLD, Messages.RECRUIT, TextColors.RESET, this.chatConfig.getFactionEndPrefix()})}).build();
    }

    private List<MessageReceiver> getAdminReceivers() {
        ArrayList<MessageReceiver> admins = new ArrayList<MessageReceiver>();
        for (UUID adminUUID : super.getPlugin().getPlayerManager().getAdminModePlayers()) {
            Optional optionalAdminPlayer = Sponge.getServer().getPlayer(adminUUID);
            optionalAdminPlayer.ifPresent(admins::add);
        }
        return admins;
    }
}

