/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.module;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.squiddev.plethora.api.module.IModuleContainer;

public class SingletonModuleContainer
implements IModuleContainer {
    private final ResourceLocation thisModule;
    private final Set<ResourceLocation> modules;

    public SingletonModuleContainer(@Nonnull ResourceLocation module) {
        Objects.requireNonNull(module, "module cannot be null");
        this.thisModule = module;
        this.modules = Collections.singleton(module);
    }

    @Override
    public boolean hasModule(@Nonnull ResourceLocation module) {
        return this.thisModule.equals((Object)module);
    }

    @Override
    @Nonnull
    public Set<ResourceLocation> getModules() {
        return this.modules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingletonModuleContainer that = (SingletonModuleContainer)o;
        return this.thisModule.equals((Object)that.thisModule);
    }

    public int hashCode() {
        return this.thisModule.hashCode();
    }
}

