/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.client;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.client.RenderInterfaceLiving;
import org.squiddev.plethora.gameplay.client.RenderSquidOverlay;
import org.squiddev.plethora.gameplay.client.entity.RenderLaser;
import org.squiddev.plethora.gameplay.client.entity.RenderMinecartComputer;
import org.squiddev.plethora.gameplay.client.tile.RenderManipulator;
import org.squiddev.plethora.gameplay.minecart.EntityMinecartComputer;
import org.squiddev.plethora.gameplay.modules.EntityLaser;
import org.squiddev.plethora.gameplay.modules.ManipulatorType;
import org.squiddev.plethora.gameplay.modules.PlethoraModules;
import org.squiddev.plethora.gameplay.modules.TileManipulator;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.utils.Helpers;

@Mod.EventBusSubscriber(modid="plethora")
public final class ClientRegistration {
    private ClientRegistration() {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        Helpers.setupModel((Item)Registration.itemNeuralInterface, 0, "neuralInterface");
        Helpers.setupModel(Registration.itemNeuralConnector, 0, "neuralConnector");
        Helpers.setupModel(Registration.itemKeyboard, 0, "keyboard");
        for (int i = 0; i < 8; ++i) {
            Helpers.setupModel(Registration.itemModule, i, "module_" + PlethoraModules.getName(i));
        }
        for (ManipulatorType type : ManipulatorType.VALUES) {
            Helpers.setupModel(Item.func_150898_a((Block)Registration.blockManipulator), type.ordinal(), "manipulator." + type.func_176610_l());
        }
        Helpers.setupModel(Item.func_150898_a((Block)Registration.blockRedstoneIntegrator), 0, "redstone_integrator");
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileManipulator.class, (TileEntitySpecialRenderer)new RenderManipulator());
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecartComputer.class, RenderMinecartComputer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLaser.class, RenderLaser::new);
    }

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        RenderSquidOverlay.init();
        RenderInterfaceLiving.init();
    }
}

