/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.PlethoraAPI;
import org.squiddev.plethora.api.method.IContextBuilder;
import org.squiddev.plethora.api.module.AbstractModuleHandler;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.gameplay.ConfigGameplay;
import org.squiddev.plethora.gameplay.ItemBase;
import org.squiddev.plethora.gameplay.client.RenderHelpers;
import org.squiddev.plethora.gameplay.modules.ChatListener;
import org.squiddev.plethora.gameplay.modules.EntityLaser;
import org.squiddev.plethora.gameplay.modules.PlethoraModules;
import org.squiddev.plethora.gameplay.modules.RangeInfo;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasServer;
import org.squiddev.plethora.integration.EntityIdentifier;
import org.squiddev.plethora.utils.Helpers;
import org.squiddev.plethora.utils.TypedField;

public final class ItemModule
extends ItemBase {
    private static final int MAX_TICKS = 72000;
    private static final int USE_TICKS = 30;
    private static final TypedField<NetHandlerPlayServer, Integer> FIELD_FLOATING_TICK_COUNT = TypedField.of(NetHandlerPlayServer.class, "floatingTickCount", "field_147365_f");
    private static final float LASER_MAX_SPREAD = 13.333334f;
    private static final double TERMINAL_VELOCITY = -2.0;

    public ItemModule() {
        super("module");
        this.func_77627_a(true);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + ".module_" + PlethoraModules.getName(stack.func_77952_i());
    }

    private static boolean isBlacklisted(ItemStack stack) {
        return ConfigCore.Blacklist.blacklistModules.contains("plethora:" + PlethoraModules.getName(stack.func_77952_i()));
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> out) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            out.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && ItemModule.isBlacklisted(stack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        switch (stack.func_77952_i()) {
            case 0: 
            case 5: {
                if (!world.field_72995_K) {
                    if (player.func_70093_af() && !player.func_146103_bH().getName().startsWith("[") && player.func_146103_bH().getId() != null) {
                        NBTTagCompound tag = ItemModule.getTag(stack);
                        if (player.func_146103_bH().equals((Object)ItemModule.getProfile(stack))) {
                            tag.func_82580_o("id_lower");
                            tag.func_82580_o("id_upper");
                            tag.func_82580_o("bound_name");
                            if (tag.func_82582_d()) {
                                stack.func_77982_d(null);
                            }
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.plethora.module.module_" + PlethoraModules.getName(stack.func_77952_i()) + ".cleared", new Object[]{player.func_70005_c_()}), true);
                        } else {
                            UUID id = player.func_146103_bH().getId();
                            tag.func_74772_a("id_lower", id.getLeastSignificantBits());
                            tag.func_74772_a("id_upper", id.getMostSignificantBits());
                            tag.func_74778_a("bound_name", player.func_70005_c_());
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.plethora.module.module_" + PlethoraModules.getName(stack.func_77952_i()) + ".bound", new Object[]{player.func_70005_c_()}), true);
                        }
                    } else if (stack.func_77952_i() == 0) {
                        player.func_71007_a((IInventory)player.func_71005_bN());
                    }
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            case 1: 
            case 4: {
                player.func_184598_c(hand);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int remaining) {
        if (world.field_72995_K) {
            return;
        }
        if (ItemModule.isBlacklisted(stack)) {
            return;
        }
        float ticks = 72000 - remaining;
        if (ticks > 30.0f) {
            ticks = 30.0f;
        }
        if (ticks < 0.0f) {
            ticks = 0.0f;
        }
        switch (stack.func_77952_i()) {
            case 1: {
                double potency = (double)(ticks / 30.0f) * (ConfigGameplay.Laser.maximumPotency - ConfigGameplay.Laser.minimumPotency) + ConfigGameplay.Laser.minimumPotency;
                double inaccuracy = (30.0f - ticks) / 30.0f * 13.333334f;
                world.func_72838_d((Entity)new EntityLaser(world, (Entity)player, (float)inaccuracy, (float)potency));
                break;
            }
            case 4: {
                ItemModule.launch((Entity)player, player.field_70177_z, player.field_70125_A, ticks / 30.0f * (float)ConfigGameplay.Kinetic.launchMax);
                break;
            }
            default: {
                super.func_77615_a(stack, world, player, remaining);
            }
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return stack.func_77952_i() == 1 || stack.func_77952_i() == 4 ? EnumAction.BOW : super.func_77661_b(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return stack.func_77952_i() == 1 || stack.func_77952_i() == 4 ? 72000 : super.func_77626_a(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || ItemModule.getLevel(stack) > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> out, ITooltipFlag flag) {
        int level;
        super.func_77624_a(stack, world, out, flag);
        String entity = ItemModule.getEntityName(stack);
        if (entity != null) {
            out.add(Helpers.translateToLocalFormatted("item.plethora.module.module_" + PlethoraModules.getName(stack.func_77952_i()) + ".binding", entity));
        }
        if ((level = ItemModule.getLevel(stack)) > 0) {
            switch (stack.func_77952_i()) {
                case 2: {
                    int range = ItemModule.getEffectiveRange(level, ConfigGameplay.Scanner.radius, ConfigGameplay.Scanner.maxRadius);
                    out.add(Helpers.translateToLocalFormatted("item.plethora.module.level", level, range));
                    break;
                }
                case 3: {
                    int range = ItemModule.getEffectiveRange(level, ConfigGameplay.Sensor.radius, ConfigGameplay.Sensor.maxRadius);
                    out.add(Helpers.translateToLocalFormatted("item.plethora.module.level", level, range));
                    break;
                }
                default: {
                    out.add(Helpers.translateToLocalFormatted("item.plethora.module.level", level, "?"));
                }
            }
        }
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound tag) {
        return new ItemModuleHandler(stack);
    }

    public static GameProfile getProfile(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("id_lower", 99) ? new GameProfile(new UUID(tag.func_74763_f("id_upper"), tag.func_74763_f("id_lower")), tag.func_74779_i("bound_name")) : null;
    }

    private static Entity getEntity(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("id_lower", 99)) {
            FMLCommonHandler handler = FMLCommonHandler.instance();
            if (handler == null) {
                return null;
            }
            MinecraftServer server = handler.getMinecraftServerInstance();
            if (server == null) {
                return null;
            }
            return server.func_175576_a(new UUID(tag.func_74763_f("id_upper"), tag.func_74763_f("id_lower")));
        }
        return null;
    }

    private static String getEntityName(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("bound_name", 8) ? tag.func_74779_i("bound_name") : null;
    }

    public static int getLevel(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("level", 99) ? tag.func_74762_e("level") : 0;
    }

    public static int getEffectiveRange(int level, int baseRange, int maxRange) {
        if (maxRange <= baseRange || level <= 0) {
            return baseRange;
        }
        return baseRange + (int)Math.ceil((1.0 - Math.pow(0.5, level)) * (double)(maxRange - baseRange));
    }

    public static int getEffectiveRange(ItemStack stack, int baseRange, int maxRange) {
        return ItemModule.getEffectiveRange(ItemModule.getLevel(stack), baseRange, maxRange);
    }

    public static void launch(Entity entity, float yaw, float pitch, float power) {
        float motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI));
        float motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI));
        float motionY = -MathHelper.func_76126_a((float)(pitch / 180.0f * (float)Math.PI));
        power /= MathHelper.func_76129_c((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184613_cA()) {
            power = (float)((double)power * ConfigGameplay.Kinetic.launchElytraScale);
        }
        entity.func_70024_g((double)(motionX * power), (double)(motionY * power) * ConfigGameplay.Kinetic.launchYScale, (double)(motionZ * power));
        entity.field_70133_I = true;
        if (ConfigGameplay.Kinetic.launchFallReset && motionY > 0.0f) {
            if (entity.field_70181_x > 0.0) {
                entity.field_70143_R = 0.0f;
            } else if (entity.field_70181_x > -2.0) {
                entity.field_70143_R = (float)((double)entity.field_70143_R * (entity.field_70181_x / -2.0));
            }
        }
        if (ConfigGameplay.Kinetic.launchFloatReset && entity instanceof EntityPlayerMP) {
            FIELD_FLOATING_TICK_COUNT.set(((EntityPlayerMP)entity).field_71135_a, 0);
        }
    }

    private static final class ItemModuleHandler
    extends AbstractModuleHandler
    implements ICapabilityProvider {
        private final ItemStack stack;
        private ResourceLocation moduleId;
        private IVehicleUpgradeHandler vehicle;

        private ItemModuleHandler(ItemStack stack) {
            this.stack = stack;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing enumFacing) {
            if (this.stack.func_77952_i() >= 8) {
                return false;
            }
            if (capability == Constants.MODULE_HANDLER_CAPABILITY) {
                return true;
            }
            if (capability == Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY) {
                return this.vehicle != null || Arrays.binarySearch(PlethoraModules.VEHICLE_MODULES, this.stack.func_77952_i()) != -1;
            }
            return false;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing enumFacing) {
            if (this.stack.func_77952_i() >= 8) {
                return null;
            }
            if (capability == Constants.MODULE_HANDLER_CAPABILITY) {
                return (T)this;
            }
            if (capability == Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY) {
                if (this.vehicle != null) {
                    return (T)this.vehicle;
                }
                if (Arrays.binarySearch(PlethoraModules.VEHICLE_MODULES, this.stack.func_77952_i()) != -1) {
                    this.vehicle = PlethoraAPI.instance().moduleRegistry().toVehicleUpgrade(this);
                    return (T)this.vehicle;
                }
                return null;
            }
            return null;
        }

        @Override
        @Nonnull
        public ResourceLocation getModule() {
            ResourceLocation id = this.moduleId;
            return id == null ? (this.moduleId = new ResourceLocation("plethora", PlethoraModules.getName(this.stack.func_77952_i()))) : id;
        }

        @Override
        public void getAdditionalContext(@Nonnull IModuleAccess access, @Nonnull IContextBuilder builder) {
            GameProfile profile;
            String moduleKey = this.moduleId.toString();
            Entity entity = ItemModule.getEntity(this.stack);
            if (entity != null) {
                builder.addContext(moduleKey, entity, Reference.entity(entity));
            }
            if ((profile = ItemModule.getProfile(this.stack)) != null) {
                builder.addContext(moduleKey, new EntityIdentifier.Player(profile));
            }
            switch (this.stack.func_77952_i()) {
                case 2: {
                    int level = ItemModule.getLevel(this.stack);
                    builder.addContext(moduleKey, RangeInfo.of(level, x -> x * ConfigGameplay.Scanner.scanLevelCost, x -> ItemModule.getEffectiveRange(x, ConfigGameplay.Scanner.radius, ConfigGameplay.Scanner.maxRadius)));
                    break;
                }
                case 3: {
                    int level = ItemModule.getLevel(this.stack);
                    builder.addContext(moduleKey, RangeInfo.of(level, x -> x * ConfigGameplay.Sensor.senseLevelCost, x -> ItemModule.getEffectiveRange(x, ConfigGameplay.Sensor.radius, ConfigGameplay.Sensor.maxRadius)));
                    break;
                }
                case 5: {
                    Object owner = access.getOwner();
                    UUID ownerId = owner instanceof Entity ? ((Entity)owner).func_110124_au() : (profile != null && ConfigGameplay.Chat.allowBinding ? profile.getId() : null);
                    ChatListener.Listener listener = new ChatListener.Listener(access, ownerId);
                    if (ownerId != null) {
                        builder.addContext(moduleKey, listener);
                    }
                    builder.addAttachable(listener);
                    break;
                }
                case 6: {
                    EntityPlayerMP ownerEntity;
                    Object owner = access.getOwner();
                    EntityPlayerMP entityPlayerMP = ownerEntity = owner instanceof EntityPlayerMP ? (EntityPlayerMP)owner : null;
                    if (ownerEntity == null || ownerEntity instanceof FakePlayer) break;
                    CanvasServer glasses = new CanvasServer(access, ownerEntity);
                    builder.addContext(moduleKey, glasses).addAttachable(glasses);
                    break;
                }
                case 7: {
                    ChatListener.CreativeListener listener = new ChatListener.CreativeListener(access);
                    builder.addContext(moduleKey, listener).addAttachable(listener);
                    break;
                }
            }
        }

        @Override
        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public Pair<IBakedModel, Matrix4f> getModel(float delta) {
            Matrix4f matrix = new Matrix4f();
            matrix.setIdentity();
            if (this.stack.func_77952_i() == 1) {
                delta = (float)(((double)delta + Math.PI) % (Math.PI * 2));
            }
            matrix.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, delta));
            return Pair.of((Object)RenderHelpers.getMesher().func_178089_a(this.stack), (Object)matrix);
        }
    }
}

