/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.methods;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.core.apis.ArgumentHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.SubtargetedModuleMethod;
import org.squiddev.plethora.gameplay.ConfigGameplay;
import org.squiddev.plethora.gameplay.modules.EntityLaser;
import org.squiddev.plethora.gameplay.modules.PlethoraModules;
import org.squiddev.plethora.utils.PlayerHelpers;

@Injects
public final class MethodsLaser {
    public static final SubtargetedModuleMethod<IWorldLocation> FIRE = SubtargetedModuleMethod.of(MethodsLaser.class.getName() + "#fire", "fire", PlethoraModules.LASER_M, IWorldLocation.class, "function(yaw:number, pitch:number, potency:number) -- Fire a laser in a set direction", MethodsLaser::fire);

    private MethodsLaser() {
    }

    @Nonnull
    private static MethodResult fire(@Nonnull IUnbakedContext<IModuleContainer> unbaked, @Nonnull Object[] args) throws LuaException {
        double yaw = ArgumentHelper.getReal((Object[])args, (int)0) % 360.0;
        double pitchArg = ArgumentHelper.getReal((Object[])args, (int)1) % 360.0;
        float potency = (float)ArgumentHelper.getReal((Object[])args, (int)2);
        if (pitchArg > 180.0) {
            pitchArg -= 360.0;
        }
        double pitch = pitchArg;
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(potency, ConfigGameplay.Laser.minimumPotency, ConfigGameplay.Laser.maximumPotency, "Potency out of range (%s).");
        double motionX = -Math.sin(yaw / 180.0 * 3.1415927410125732) * Math.cos(pitch / 180.0 * 3.1415927410125732);
        double motionZ = Math.cos(yaw / 180.0 * 3.1415927410125732) * Math.cos(pitch / 180.0 * 3.1415927410125732);
        double motionY = -Math.sin(pitch / 180.0 * 3.1415927410125732);
        return unbaked.getCostHandler().await((double)potency * ConfigGameplay.Laser.cost, MethodResult.nextTick(() -> {
            IContext context = unbaked.bake();
            IWorldLocation location = context.getContext("origin", IWorldLocation.class);
            Vec3d pos = location.getLoc();
            EntityLaser laser = new EntityLaser(location.getWorld(), pos);
            IPlayerOwnable ownable = context.getContext("origin", IPlayerOwnable.class);
            Entity entity = context.getContext("origin", Entity.class);
            GameProfile profile = null;
            if (ownable != null) {
                profile = ownable.getOwningProfile();
            }
            if (profile == null) {
                profile = PlayerHelpers.getProfile(entity);
            }
            laser.setShooter(entity, profile);
            if (context.hasContext(TileEntity.class) || context.hasContext(ITurtleAccess.class)) {
                double zOffset;
                double yOffset;
                double xOffset;
                double vOff = 0.3;
                if (pitch < -60.0) {
                    xOffset = 0.0;
                    yOffset = 0.5 + vOff;
                    zOffset = 0.0;
                } else if (pitch > 60.0) {
                    xOffset = 0.0;
                    yOffset = -0.5 - vOff;
                    zOffset = 0.0;
                } else {
                    double hOff = 0.9;
                    double length = Math.sqrt(motionX * motionX + motionZ * motionZ);
                    xOffset = motionX / length * hOff;
                    yOffset = 0.0;
                    zOffset = motionZ / length * hOff;
                }
                laser.func_70107_b(pos.field_72450_a + xOffset, pos.field_72448_b + yOffset, pos.field_72449_c + zOffset);
            } else if (context.hasContext(Entity.class)) {
                Entity entity2 = context.getContext(Entity.class);
                Vec3d vector = entity2.func_174791_d();
                double offset = (double)entity2.field_70130_N + 0.2;
                double length = Math.sqrt(motionX * motionX + motionY * motionY + motionZ * motionZ);
                laser.func_70107_b(vector.field_72450_a + motionX / length * offset, vector.field_72448_b + (double)entity2.func_70047_e() + motionY / length * offset, vector.field_72449_c + motionZ / length * offset);
            } else {
                laser.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
            laser.setPotency(potency);
            laser.func_70186_c(motionX, motionY, motionZ, 1.5f, 0.0f);
            location.getWorld().func_72838_d((Entity)laser);
            return MethodResult.empty();
        }));
    }
}

