/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.astralsorcery;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.starmap.ActiveStarMap;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.item.ItemColoredLens;
import hellfirepvp.astralsorcery.common.item.ItemConstellationPaper;
import hellfirepvp.astralsorcery.common.item.ItemInfusedGlass;
import hellfirepvp.astralsorcery.common.item.ItemJournal;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.item.tool.ItemSkyResonator;
import hellfirepvp.astralsorcery.common.item.tool.sextant.ItemSextant;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantTargets;
import hellfirepvp.astralsorcery.common.item.tool.wand.ItemWand;
import hellfirepvp.astralsorcery.common.item.tool.wand.WandAugment;
import hellfirepvp.astralsorcery.common.item.wand.ItemIlluminationWand;
import hellfirepvp.astralsorcery.common.item.wearable.ItemCape;
import hellfirepvp.astralsorcery.common.item.wearable.ItemEnchantmentAmulet;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.meta.ItemStackContextMetaProvider;
import org.squiddev.plethora.api.meta.ItemStackMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.utils.Helpers;

@Injects(value="astralsorcery")
public final class MetaItems {
    public static final IMetaProvider<ItemStack> META_TUNED_CRYSTAL_BASE = new ItemStackContextMetaProvider<ItemTunedCrystalBase>(ItemTunedCrystalBase.class, "Provides the constellation(s) for an item"){

        @Override
        @Nonnull
        public Map<String, Object> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemTunedCrystalBase item) {
            IMinorConstellation trait;
            ItemStack stack = context.getTarget();
            HashMap<String, Object> out = new HashMap<String, Object>(2);
            IConstellation constellation = item.getFocusConstellation(stack);
            if (constellation != null) {
                out.put("constellationFocus", context.makePartialChild(constellation).getMeta());
            }
            if ((trait = ItemTunedCrystalBase.getTrait((ItemStack)stack)) != null) {
                out.put("constellationTrait", context.makePartialChild(trait).getMeta());
            }
            return out;
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack crystalStack = new ItemStack((Item)ItemsAS.tunedRockCrystal);
            CrystalProperties.applyCrystalProperties((ItemStack)crystalStack, (CrystalProperties)CrystalProperties.getMaxRockProperties());
            ItemTunedCrystalBase.applyMainConstellation((ItemStack)crystalStack, (IWeakConstellation)Constellations.discidia);
            ItemTunedCrystalBase.applyTrait((ItemStack)crystalStack, (IMinorConstellation)Constellations.gelu);
            return crystalStack;
        }
    };
    public static final IMetaProvider<ItemStack> META_CONSTELLATION_PAPER = new ItemStackContextMetaProvider<ItemConstellationPaper>(ItemConstellationPaper.class, "Provides the Constellation for a Constellation Paper"){

        @Override
        @Nonnull
        public Map<String, Object> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemConstellationPaper item) {
            IConstellation constellation = ItemConstellationPaper.getConstellation((ItemStack)context.getTarget());
            return constellation != null ? Collections.singletonMap("constellation", context.makePartialChild(constellation).getMeta()) : Collections.emptyMap();
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack paperStack = new ItemStack((Item)ItemsAS.constellationPaper);
            ItemConstellationPaper.setConstellation((ItemStack)paperStack, (IConstellation)Constellations.discidia);
            return paperStack;
        }
    };
    public static final IMetaProvider<ItemStack> META_ITEM_JOURNAL = new ItemStackContextMetaProvider<ItemJournal>(ItemJournal.class, "Provides the Constellations stored in a Journal"){

        @Override
        @Nonnull
        public Map<String, Object> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemJournal item) {
            return Collections.singletonMap("papers", LuaList.of(ItemJournal.getStoredConstellations((ItemStack)context.getTarget()), paper -> context.makePartialChild(paper).getMeta()).asMap());
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack((Item)ItemsAS.journal);
            LinkedList<IMajorConstellation> constellations = new LinkedList<IMajorConstellation>();
            constellations.add(Constellations.discidia);
            ItemJournal.setStoredConstellations((ItemStack)stack, constellations);
            return stack;
        }
    };
    public static final IMetaProvider<ItemStack> META_SKY_RESONATOR = new ItemStackMetaProvider<ItemSkyResonator>(ItemSkyResonator.class, "Provides the available modes for a Resonator"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ItemStack stack, @Nonnull ItemSkyResonator item) {
            List modes = ItemSkyResonator.getUpgrades((ItemStack)stack);
            LuaList modesOut = new LuaList(modes.size());
            for (ItemSkyResonator.ResonatorUpgrade mode : modes) {
                HashMap<String, String> modeMap = new HashMap<String, String>(2);
                String translationKey = mode.getUnlocalizedUpgradeName();
                modeMap.put("name", translationKey);
                modeMap.put("displayName", Helpers.translateToLocal(translationKey));
                modesOut.add(modeMap);
            }
            return Collections.singletonMap("modes", modesOut.asMap());
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack((Item)ItemsAS.skyResonator);
            ItemSkyResonator.setEnhanced((ItemStack)stack);
            ItemSkyResonator.setUpgradeUnlocked((ItemStack)stack, (ItemSkyResonator.ResonatorUpgrade)ItemSkyResonator.ResonatorUpgrade.AREA_SIZE);
            ItemSkyResonator.setUpgradeUnlocked((ItemStack)stack, (ItemSkyResonator.ResonatorUpgrade)ItemSkyResonator.ResonatorUpgrade.FLUID_FIELDS);
            return stack;
        }
    };
    public static final IMetaProvider<ItemStack> META_COLORED_LENS = new ItemStackMetaProvider<ItemColoredLens>(ItemColoredLens.class, "Provides the color of a lens"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ItemStack stack, @Nonnull ItemColoredLens item) {
            String colorName;
            ItemColoredLens.ColorType[] colors = ItemColoredLens.ColorType.values();
            int meta = stack.func_77960_j();
            String string = colorName = meta >= colors.length || meta < 0 ? null : colors[meta].getUnlocalizedName();
            if (colorName == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> out = new HashMap<String, String>(2);
            out.put("lensColor", colorName);
            out.put("lensColour", colorName);
            return out;
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            return new ItemStack((Item)ItemsAS.coloredLens, 1, ItemColoredLens.ColorType.SPECTRAL.getMeta());
        }
    };
    public static final IMetaProvider<ItemStack> META_RESPLENDENT_PRISM = new ItemStackContextMetaProvider<ItemEnchantmentAmulet>(ItemEnchantmentAmulet.class, "Provides the enchantment bonuses for a Resplendent Prism"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemEnchantmentAmulet item) {
            return Collections.singletonMap("amuletEnchantments", LuaList.of(ItemEnchantmentAmulet.getAmuletEnchantments((ItemStack)context.getTarget()), e -> context.makePartialChild(e).getMeta()).asMap());
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack((Item)ItemsAS.enchantmentAmulet);
            ItemEnchantmentAmulet.freezeAmuletColor((ItemStack)stack);
            ArrayList<AmuletEnchantment> enchants = new ArrayList<AmuletEnchantment>(3);
            Enchantment looting = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("looting"));
            if (looting != null) {
                enchants.add(new AmuletEnchantment(DynamicEnchantment.Type.ADD_TO_EXISTING_SPECIFIC, looting, 1));
            }
            enchants.add(new AmuletEnchantment(DynamicEnchantment.Type.ADD_TO_EXISTING_ALL, 2));
            ItemEnchantmentAmulet.setAmuletEnchantments((ItemStack)stack, enchants);
            return stack;
        }
    };
    public static final IMetaProvider<ItemStack> META_MANTLE_OF_THE_STARS = new ItemStackContextMetaProvider<ItemCape>(ItemCape.class, "Provides the constellation a Mantle of the Stars is attuned to"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemCape item) {
            IConstellation constellation = ItemCape.getAttunedConstellation((ItemStack)context.getTarget());
            return constellation != null ? Collections.singletonMap("constellation", context.makePartialChild(constellation).getMeta()) : Collections.emptyMap();
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack((Item)ItemsAS.armorImbuedCape);
            ItemCape.setAttunedConstellation((ItemStack)stack, (IConstellation)Constellations.discidia);
            return stack;
        }
    };
    public static final IMetaProvider<ItemStack> META_ILLUMINATION_WAND = new ItemStackMetaProvider<ItemIlluminationWand>(ItemIlluminationWand.class, "Provides the color of flares placed by an Illumination Wand"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ItemStack stack, @Nonnull ItemIlluminationWand item) {
            EnumDyeColor color = ItemIlluminationWand.getConfiguredColor((ItemStack)stack);
            if (color == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> out = new HashMap<String, String>(2);
            out.put("flareColor", color.toString());
            out.put("flareColour", color.toString());
            return out;
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack wand = new ItemStack((Item)ItemsAS.illuminationWand);
            ItemIlluminationWand.setConfiguredColor((ItemStack)wand, (EnumDyeColor)EnumDyeColor.YELLOW);
            return wand;
        }
    };
    public static final IMetaProvider<ItemStack> META_RESONATING_WAND = new ItemStackContextMetaProvider<ItemWand>(ItemWand.class, "Provides the constellation a Resonating Wand is attuned to"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemWand item) {
            WandAugment augment = ItemWand.getAugment((ItemStack)context.getTarget());
            if (augment == null) {
                return Collections.emptyMap();
            }
            IMajorConstellation constellation = augment.getAssociatedConstellation();
            return constellation != null ? Collections.singletonMap("constellation", context.makePartialChild(constellation).getMeta()) : Collections.emptyMap();
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack((Item)ItemsAS.wand);
            ItemWand.setAugment((ItemStack)stack, (WandAugment)WandAugment.DISCIDIA);
            return stack;
        }
    };
    public static final IMetaProvider<ItemStack> META_INFUSED_GLASS = new ItemStackContextMetaProvider<ItemInfusedGlass>(ItemInfusedGlass.class, "Provides the constellations etched on an Infused Glass"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemInfusedGlass item) {
            ActiveStarMap starMap = ItemInfusedGlass.getMapEngravingInformations((ItemStack)context.getTarget());
            return starMap == null ? Collections.emptyMap() : Collections.singletonMap("constellations", LuaList.of(starMap.getConstellations(), c -> context.makePartialChild(c).getMeta()).asMap());
        }

        @Override
        @Nullable
        public ItemStack getExample() {
            return null;
        }
    };
    public static final IMetaProvider<ItemStack> META_SEXTANT = new ItemStackMetaProvider<ItemSextant>(ItemSextant.class, "Provides the active target of a Sextant, and whether the Sextant is augmented"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ItemStack stack, @Nonnull ItemSextant item) {
            HashMap<String, Object> out = new HashMap<String, Object>(2);
            out.put("augmented", ItemSextant.isAdvanced((ItemStack)stack));
            SextantFinder.TargetObject target = ItemSextant.getTarget((ItemStack)stack);
            if (target != null) {
                out.put("targetType", target.getRegistryName());
            }
            return out;
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack((Item)ItemsAS.sextant);
            ItemSextant.setAdvanced((ItemStack)stack);
            ItemSextant.setTarget((ItemStack)stack, (SextantFinder.TargetObject)SextantTargets.TARGET_SMALL_SHRINE);
            return stack;
        }
    };

    private MetaItems() {
    }
}

