/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.computercraft;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.WeakHashMap;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.gameplay.PlethoraFakePlayer;

public final class FakePlayerProviderTurtle {
    private static final WeakHashMap<ITurtleAccess, PlethoraFakePlayer> registeredPlayers = new WeakHashMap();

    private FakePlayerProviderTurtle() {
    }

    public static PlethoraFakePlayer getPlayer(ITurtleAccess entity, IPlayerOwnable ownable) {
        return FakePlayerProviderTurtle.getPlayer(entity, ownable == null ? null : ownable.getOwningProfile());
    }

    public static PlethoraFakePlayer getPlayer(ITurtleAccess turtle, GameProfile profile) {
        PlethoraFakePlayer fake = registeredPlayers.get(turtle);
        if (fake == null) {
            fake = new PlethoraFakePlayer((WorldServer)turtle.getWorld(), null, profile);
            registeredPlayers.put(turtle, fake);
        }
        return fake;
    }

    public static void load(PlethoraFakePlayer player, ITurtleAccess turtle, EnumFacing direction) {
        int i;
        player.func_70029_a(turtle.getWorld());
        BlockPos position = turtle.getPosition();
        player.func_70080_a((double)position.func_177958_n() + 0.5 + 0.51 * (double)direction.func_82601_c(), (double)position.func_177956_o() + 0.5 + 0.51 * (double)direction.func_96559_d(), (double)position.func_177952_p() + 0.5 + 0.51 * (double)direction.func_82599_e(), (direction.func_176740_k() != EnumFacing.Axis.Y ? direction : turtle.getDirection()).func_185119_l(), direction.func_176740_k() != EnumFacing.Axis.Y ? 0.0f : DirectionUtil.toPitchAngle((EnumFacing)direction));
        player.func_70105_a(1.0f, 1.0f);
        player.eyeHeight = 0.0f;
        player.func_70095_a(false);
        player.field_71071_by.field_70461_c = 0;
        IItemHandlerModifiable turtleInventory = turtle.getItemHandler();
        int size = turtleInventory.getSlots();
        int largerSize = player.field_71071_by.func_70302_i_();
        player.field_71071_by.field_70461_c = turtle.getSelectedSlot();
        for (i = 0; i < size; ++i) {
            player.field_71071_by.func_70299_a(i, turtleInventory.getStackInSlot(i));
        }
        for (i = size; i < largerSize; ++i) {
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        player.field_71071_by.func_70296_d();
        ItemStack activeStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!activeStack.func_190926_b()) {
            player.func_110140_aT().func_111147_b(activeStack.func_111283_C(EntityEquipmentSlot.MAINHAND));
        }
    }

    public static void unload(PlethoraFakePlayer player, ITurtleAccess turtle) {
        int i;
        player.field_71071_by.field_70461_c = 0;
        player.func_70105_a(0.0f, 0.0f);
        player.eyeHeight = player.getDefaultEyeHeight();
        ItemStack activeStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!activeStack.func_190926_b()) {
            player.func_110140_aT().func_111148_a(activeStack.func_111283_C(EntityEquipmentSlot.MAINHAND));
        }
        IItemHandlerModifiable turtleInventory = turtle.getItemHandler();
        int size = turtleInventory.getSlots();
        int largerSize = player.field_71071_by.func_70302_i_();
        player.field_71071_by.field_70461_c = turtle.getSelectedSlot();
        for (i = 0; i < size; ++i) {
            turtleInventory.setStackInSlot(i, player.field_71071_by.func_70301_a(i));
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        for (i = size; i < largerSize; ++i) {
            ItemStack remaining = player.field_71071_by.func_70301_a(i);
            if (!remaining.func_190926_b() && !(remaining = ItemHandlerHelper.insertItem((IItemHandler)turtleInventory, (ItemStack)remaining, (boolean)false)).func_190926_b()) {
                BlockPos position = turtle.getPosition();
                WorldUtil.dropItemStack((ItemStack)remaining, (World)turtle.getWorld(), (BlockPos)position, (EnumFacing)turtle.getDirection().func_176734_d());
            }
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        player.field_71071_by.func_70296_d();
    }
}

