/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.computercraft;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.api.turtle.event.TurtleInspectItemEvent;
import dan200.computercraft.api.turtle.event.TurtleRefuelEvent;
import dan200.computercraft.shared.peripheral.common.ItemPeripheralBase;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.IPeripheralHandler;
import org.squiddev.plethora.api.TurtleWorldLocation;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.SingletonModuleContainer;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.core.ContextFactory;
import org.squiddev.plethora.core.PartialContext;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.TurtleUpgradeModule;
import org.squiddev.plethora.core.capabilities.DefaultCostHandler;
import org.squiddev.plethora.gameplay.ConfigGameplay;
import org.squiddev.plethora.gameplay.client.RenderHelpers;
import org.squiddev.plethora.gameplay.modules.PlethoraModules;
import org.squiddev.plethora.integration.computercraft.FERefuelHandler;
import org.squiddev.plethora.integration.computercraft.SpeakerPeripheralBase;
import org.squiddev.plethora.integration.computercraft.WirelessModemPeripheralBase;
import org.squiddev.plethora.integration.vanilla.meta.MetaItemBasic;

@Mod.EventBusSubscriber(modid="plethora-core")
public final class IntegrationComputerCraft {
    private IntegrationComputerCraft() {
    }

    @SubscribeEvent
    @Optional.Method(modid="computercraft")
    public static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_77973_b() instanceof ItemPeripheralBase) {
            event.addCapability(PlethoraCore.PERIPHERAL_HANDLER_KEY, (ICapabilityProvider)new PeripheralCapabilityProvider(stack));
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="computercraft")
    public static void onItemInspect(TurtleInspectItemEvent event) {
        event.addData(MetaItemBasic.getBasicMeta(event.getStack()));
    }

    @SubscribeEvent
    @Optional.Method(modid="computercraft")
    public static void onBlockInspect(TurtleBlockEvent.Inspect event) {
        ITurtleAccess turtle = event.getTurtle();
        ITurtleUpgrade left = turtle.getUpgrade(TurtleSide.Left);
        ITurtleUpgrade right = turtle.getUpgrade(TurtleSide.Right);
        if (left != null && left.getUpgradeID().equals((Object)PlethoraModules.SCANNER_M) || right != null && right.getUpgradeID().equals((Object)PlethoraModules.SCANNER_M)) {
            IBlockState state = event.getState();
            SingletonModuleContainer container = new SingletonModuleContainer(PlethoraModules.SCANNER_M);
            TypedMeta metadata = ((PartialContext)((Object)((ContextFactory)((ContextFactory)((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(state, Reference.id(state)).withCostHandler(DefaultCostHandler.get(turtle))).withModules((IModuleContainer)container, Reference.id(container))).addContext("origin", new TurtleUpgradeModule.TurtlePlayerOwnable(turtle))).addContext("origin", new TurtleWorldLocation(turtle))).addContext("origin", turtle, (IReference)Reference.id(turtle))).getBaked())).getMeta();
            event.addData(metadata);
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="computercraft")
    public static void onTurtleRefuel(TurtleRefuelEvent event) {
        if (event.getHandler() != null) {
            return;
        }
        if (ConfigGameplay.Turtle.feFuelRatio > 0 && event.getStack().hasCapability(CapabilityEnergy.ENERGY, null)) {
            event.setHandler((TurtleRefuelEvent.Handler)FERefuelHandler.INSTANCE);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="computercraft")
    public static void onModelBakeEvent(ModelBakeEvent event) {
        RenderHelpers.loadModel(event, "computercraft", "wireless_modem_off");
        RenderHelpers.loadModel(event, "computercraft", "wireless_modem_on");
        RenderHelpers.loadModel(event, "computercraft", "advanced_modem_off");
        RenderHelpers.loadModel(event, "computercraft", "advanced_modem_on");
    }

    private static final class PeripheralCapabilityProvider
    implements ICapabilityProvider {
        private boolean checkedPeripheral = false;
        private IPeripheralHandler peripheral;
        private boolean checkedVehicle = false;
        private IVehicleUpgradeHandler vehicle;
        private final ItemStack stack;

        private PeripheralCapabilityProvider(ItemStack stack) {
            this.stack = stack;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing enumFacing) {
            if (capability == Constants.PERIPHERAL_HANDLER_CAPABILITY) {
                return this.getHandler() != null;
            }
            if (capability == Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY) {
                return this.getVehicle() != null;
            }
            return false;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing enumFacing) {
            if (capability == Constants.PERIPHERAL_HANDLER_CAPABILITY) {
                return (T)this.getHandler();
            }
            if (capability == Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY) {
                return (T)this.getVehicle();
            }
            return null;
        }

        private IPeripheralHandler getHandler() {
            if (this.checkedPeripheral) {
                return this.peripheral;
            }
            this.checkedPeripheral = true;
            if (this.stack.func_77973_b() instanceof ItemPeripheralBase) {
                ItemPeripheralBase item = (ItemPeripheralBase)this.stack.func_77973_b();
                switch (item.getPeripheralType(this.stack)) {
                    case WirelessModem: {
                        this.peripheral = new WirelessModemPeripheralBase.PeripheralHandler(false, this.stack);
                        return this.peripheral;
                    }
                    case AdvancedModem: {
                        this.peripheral = new WirelessModemPeripheralBase.PeripheralHandler(true, this.stack);
                        return this.peripheral;
                    }
                    case Speaker: {
                        this.peripheral = new SpeakerPeripheralBase.PeripheralHandler(this.stack);
                        return this.peripheral;
                    }
                }
                return null;
            }
            return null;
        }

        private IVehicleUpgradeHandler getVehicle() {
            if (this.checkedVehicle) {
                return this.vehicle;
            }
            this.checkedVehicle = true;
            if (this.stack.func_77973_b() instanceof ItemPeripheralBase) {
                ItemPeripheralBase item = (ItemPeripheralBase)this.stack.func_77973_b();
                switch (item.getPeripheralType(this.stack)) {
                    case WirelessModem: {
                        this.vehicle = new WirelessModemPeripheralBase.VehicleUpgradeHandler(false, this.stack);
                        return this.vehicle;
                    }
                    case AdvancedModem: {
                        this.vehicle = new WirelessModemPeripheralBase.VehicleUpgradeHandler(true, this.stack);
                        return this.vehicle;
                    }
                    case Speaker: {
                        this.vehicle = new SpeakerPeripheralBase.VehicleUpgradeHandler(this.stack);
                        return this.vehicle;
                    }
                }
                return null;
            }
            return null;
        }
    }
}

