/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;

@Injects
public final class MetaBlockState
extends BaseMetaProvider<IBlockState> {
    public MetaBlockState() {
        super("Provides some very basic information about a block and its associated state.");
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<IBlockState> context) {
        IBlockState state = context.getTarget();
        Block block = state.func_177230_c();
        HashMap<String, Object> data = new HashMap<String, Object>();
        MetaBlockState.fillBasicMeta(data, state);
        Material material = state.func_185904_a();
        data.put("material", context.makePartialChild(material).getMeta());
        int level = block.getHarvestLevel(state);
        if (level >= 0) {
            data.put("harvestLevel", level);
        }
        data.put("harvestTool", block.getHarvestTool(state));
        return data;
    }

    public static void fillBasicMeta(@Nonnull Map<? super String, Object> data, @Nonnull IBlockState state) {
        Map propertyMap;
        Block block = state.func_177230_c();
        data.put("metadata", block.func_176201_c(state));
        ImmutableMap properties = state.func_177228_b();
        if (properties.isEmpty()) {
            propertyMap = Collections.emptyMap();
        } else {
            propertyMap = new HashMap(properties.size());
            for (Map.Entry item : properties.entrySet()) {
                Object value = item.getValue();
                if (!(value instanceof String || value instanceof Number || value instanceof Boolean)) {
                    value = value.toString();
                }
                propertyMap.put(((IProperty)item.getKey()).func_177701_a(), value);
            }
        }
        data.put("state", propertyMap);
    }

    @Override
    public IBlockState getExample() {
        return Blocks.field_150348_b.func_176223_P();
    }
}

