/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.command;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mcsimonflash.sponge.cmdcontrol.command.parser.SourceParser;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdUtils;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Aliases;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Command;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Permission;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;

@Singleton
@Aliases(value={"message", "msg"})
@Permission(value="cmdcontrol.command.message.base")
public class Message
extends Command {
    private static final Pattern MODIFIERS = Pattern.compile("\\[(.+?)]\\((.+?)\\)");

    @Inject
    private Message(Command.Settings settings) {
        super(settings.elements(SourceParser.PARSER.toElement("source"), Arguments.remainingStrings().toElement("message")).usage(CmdUtils.usage("/cmdcontrol message ", CmdUtils.info("Message", "Sends an un-prefixed message to a source.\n", "", "message, msg\n", "cmdcontrol.command.message.base"), CmdUtils.arg(true, "source", CmdUtils.info("Source", "The source to receive the message\n", "CommandSource (player, #console, or #server)\n", "", "")), CmdUtils.arg(true, "message", CmdUtils.info("Message", "The message to be sent\n", "Text (supports legacy (&) formatting)\n", "", "")))));
    }

    public CommandResult execute(CommandSource src, CommandContext args) {
        String message = (String)args.getOne("message").get();
        Matcher matcher = MODIFIERS.matcher(message);
        Text.Builder builder = Text.builder();
        int index = 0;
        while (matcher.find()) {
            if (matcher.start() > index) {
                builder.append(new Text[]{CmdUtils.toText(message.substring(index, matcher.start()))});
            }
            Text.Builder subtext = CmdUtils.toText(matcher.group(1)).toBuilder();
            String group = matcher.group(2);
            try {
                subtext.onClick((ClickAction)(group.startsWith("/") ? TextActions.runCommand((String)group) : TextActions.openUrl((URL)new URL(group))));
                subtext.onHover((HoverAction)TextActions.showText((Text)Text.of((String)group)));
            }
            catch (MalformedURLException e) {
                subtext.onHover((HoverAction)TextActions.showText((Text)CmdUtils.toText(group)));
            }
            builder.append(new Text[]{subtext.build()});
            index = matcher.end();
            if (!matcher.hitEnd() || index >= message.length()) continue;
            builder.append(new Text[]{CmdUtils.toText(message.substring(index))});
        }
        if (index == 0) {
            builder.append(new Text[]{CmdUtils.toText(message)});
        }
        ((CommandSource)args.getOne("source").get()).sendMessage(builder.build());
        return CommandResult.success();
    }
}

