/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy;

import asmodeuscore.core.prefab.celestialbody.Comet;
import asmodeuscore.core.prefab.celestialbody.SpacePort;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class SpaceData {
    public static final String rocket_tier = "rocket_tier";
    public static final String rocket_engine = "rocket_engine";
    public static final String rocket_count_fuel = "rocket_count_fuel";
    private static Map<String, Object> map = new HashMap<String, Object>();
    static int maxSpacePortID = 0;
    static int maxCometID = 0;
    static HashMap<String, SpacePort> spaceports = Maps.newHashMap();
    static BiMap<String, Integer> spaceportIDs = HashBiMap.create();
    static Map<String, Comet> comets = Maps.newHashMap();
    static BiMap<String, Integer> cometsIDs = HashBiMap.create();

    public void addToMap(String name, Object obj) {
        map.put(name, obj);
    }

    public Map getMap() {
        return map;
    }

    public Object getValue(String name) {
        return map.get(name);
    }

    public static boolean registerSpaceport(SpacePort spaceport) {
        if (spaceportIDs.containsKey((Object)spaceport.getName())) {
            return false;
        }
        spaceports.put(spaceport.getName(), spaceport);
        spaceportIDs.put((Object)spaceport.getName(), (Object)(++maxSpacePortID));
        return true;
    }

    public static Map<String, SpacePort> getRegisteredSpaceports() {
        return ImmutableMap.copyOf(spaceports);
    }

    public static Map<String, Integer> getRegisteredSpaceportIDs() {
        return ImmutableMap.copyOf(spaceportIDs);
    }

    public static int getSpaceportID(String spaceportName) {
        return (Integer)spaceportIDs.get((Object)spaceportName);
    }

    public static boolean registerComet(Comet comet) {
        if (cometsIDs.containsKey((Object)comet.getName())) {
            return false;
        }
        comets.put(comet.getName(), comet);
        cometsIDs.put((Object)comet.getName(), (Object)(++maxCometID));
        return true;
    }

    public static Map<String, Comet> getRegisteredComets() {
        return ImmutableMap.copyOf(comets);
    }

    public static Map<String, Integer> getRegisteredCometsIDs() {
        return ImmutableMap.copyOf(cometsIDs);
    }

    public static int getCometID(String cometName) {
        return (Integer)cometsIDs.get((Object)cometName);
    }

    public static enum Engine_Type {
        FUEL_ENGINE(0, "fuel_engine"),
        ION_ENGINE(1, "ion_engine"),
        PLASMA_ENGINE(2, "plasma_engine"),
        SUBLIGHT_ENGINE(3, "sublight_engine"),
        BLACKHOLE_ENGINE(4, "blackhole_engine");

        String name;
        int id;
        private static final Engine_Type[] values;

        private Engine_Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getID() {
            return this.id;
        }

        public static Engine_Type byID(int id) {
            return values[id % values.length];
        }

        static {
            values = Engine_Type.values();
        }
    }
}

