/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine;

import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen_InXYZ;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen_InXZ;
import asmodeuscore.core.utils.worldengine.perlinnoise.PerlinNoise;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_BiomeLayer;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_GrassGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_LakeGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_SnowGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_WorldTreeGen;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WE_Biome
extends Biome {
    public int id;
    public double biomeMinValueOnMap = -1.0;
    public double biomeMaxValueOnMap = 1.0;
    public double biomePersistence = 1.0;
    public double biomeScaleX = 1.0;
    public double biomeScaleY = 1.0;
    public double biomeTemerature = 0.0;
    public int biomeNumberOfOctaves = 1;
    public int biomeSurfaceHeight = 63;
    public int biomeInterpolateQuality = 16;
    public int biomeBlockGrassColor;
    public int biomeBlockWaterColor;
    public int biomeBlockLeavesColor;
    public boolean biomeAbs = false;
    public List<WE_CreateChunkGen_InXZ> createChunkGen_InXZ_List = new ArrayList<WE_CreateChunkGen_InXZ>();
    public List<WE_CreateChunkGen_InXYZ> createChunkGen_InXYZ_List = new ArrayList<WE_CreateChunkGen_InXYZ>();
    public List<IWorldGenerator> decorateChunkGen_List = new ArrayList<IWorldGenerator>();
    private static WE_ChunkProvider chunk_provider;

    public WE_Biome(Biome.BiomeProperties prop) {
        super(prop);
        this.setRegistryName(prop.field_185412_a);
    }

    public WE_Biome(Biome.BiomeProperties prop, int[] colors) {
        this(prop);
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.biomeBlockGrassColor = colors[0];
        this.biomeBlockWaterColor = colors[1];
        this.biomeBlockLeavesColor = colors[2];
        WE_BiomeLayer standardBiomeLayers = new WE_BiomeLayer();
        standardBiomeLayers.add(Blocks.field_150346_d.func_176223_P(), Blocks.field_150348_b.func_176223_P(), -256, 0, -4, -2, true);
        standardBiomeLayers.add(Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), -256, 0, -256, 0, false);
        standardBiomeLayers.add(Blocks.field_150357_h.func_176223_P(), 0, 2, 0, 0, true);
        this.createChunkGen_InXZ_List.add(standardBiomeLayers);
        this.createChunkGen_InXZ_List.add(new WE_SnowGen());
        this.decorateChunkGen_List.add(new WE_LakeGen());
        WE_WorldTreeGen treeGen = new WE_WorldTreeGen();
        treeGen.add(Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0, Blocks.field_150345_g, Blocks.field_150395_bd, Blocks.field_150375_by, 8, 1, 8, 4, false, (byte)2, (byte)0, (byte)0, (byte)1, (byte)2, (byte)1, 1, 12, 4, 0.618, 0.381, 1.0, 1.0);
        this.decorateChunkGen_List.add(treeGen);
        WE_GrassGen grassGen = new WE_GrassGen();
        grassGen.add(Blocks.field_150329_H.func_176203_a(1), 8, false, Blocks.field_150349_c.func_176223_P());
        grassGen.add(Blocks.field_150329_H.func_176203_a(2), 16, false, Blocks.field_150349_c.func_176223_P());
        grassGen.add(Blocks.field_150328_O.func_176223_P(), 128, false, Blocks.field_150349_c.func_176223_P());
        grassGen.add(Blocks.field_150327_N.func_176223_P(), 128, false, Blocks.field_150349_c.func_176223_P());
        grassGen.add(Blocks.field_150330_I.func_176223_P(), 512, false, Blocks.field_150349_c.func_176223_P());
        grassGen.add(Blocks.field_150392_bi.func_176223_P(), 256, false, Blocks.field_150355_j.func_176223_P());
        this.decorateChunkGen_List.add(grassGen);
    }

    public WE_Biome(Biome.BiomeProperties prop, double minMapValue, double maxMapValue, double persistence, int numOctaves, double sx, double sy, int height, int interpolateQuality, int[] colors) {
        this(prop, colors);
        this.biomeMinValueOnMap = minMapValue;
        this.biomeMaxValueOnMap = maxMapValue;
        this.biomePersistence = persistence;
        this.biomeNumberOfOctaves = numOctaves;
        this.biomeScaleX = sx;
        this.biomeScaleY = sy;
        this.biomeSurfaceHeight = height;
        this.biomeInterpolateQuality = interpolateQuality;
    }

    public WE_Biome setAbsoluteValue() {
        this.biomeAbs = true;
        this.biomeMinValueOnMap = Math.abs(this.biomeMinValueOnMap);
        this.biomeMaxValueOnMap = Math.abs(this.biomeMaxValueOnMap);
        return this;
    }

    public static void setBiomeMap(WE_ChunkProvider cp, double persistence, int numOctaves, double sx, double sy) {
        cp.biomemapPersistence = persistence;
        cp.biomemapNumberOfOctaves = numOctaves;
        cp.biomemapScaleX = sx;
        cp.biomemapScaleY = sy;
    }

    public static int addBiomeToGeneration(WE_ChunkProvider cp, WE_Biome biome) {
        if (biome.biomeMaxValueOnMap < biome.biomeMinValueOnMap) {
            double t = biome.biomeMaxValueOnMap;
            biome.biomeMaxValueOnMap = biome.biomeMinValueOnMap;
            biome.biomeMinValueOnMap = t;
        }
        cp.biomesList.add(biome);
        biome.id = cp.biomesList.size();
        if (cp.standardBiomeOnMap == null) {
            cp.standardBiomeOnMap = biome;
        }
        return biome.id;
    }

    public static void setChunkProvider(WE_ChunkProvider prov) {
        chunk_provider = prov;
    }

    public void decorateBiome(World world, Random rand, int x, int z) {
    }

    public static WE_Biome getBiomeAt(long x, long z) {
        return WE_Biome.getBiomeAt(chunk_provider, x, z);
    }

    public static WE_Biome getBiomeAt(WE_ChunkProvider cp, long x, long z) {
        double biomeMapData = 0.0;
        PerlinNoise noise = new PerlinNoise(cp.worldObj.func_72905_C(), cp.biomemapPersistence, cp.biomemapNumberOfOctaves, cp.biomemapScaleX, cp.biomemapScaleY, 0);
        biomeMapData = noise.genNoise2d(x, z);
        PerlinNoise noise_river = new PerlinNoise(cp.worldObj.func_72905_C(), 0.2, 1, 1500.0, 0.5, 0);
        double river = noise_river.genNoise2d(x, z);
        WE_Biome r = null;
        for (int i = 0; i < cp.biomesList.size(); ++i) {
            WE_Biome getBiome = cp.biomesList.get(i);
            if (getBiome.biomeAbs) {
                if (!(biomeMapData >= getBiome.biomeMaxValueOnMap)) continue;
                if (r != null) {
                    if (!(getBiome.biomeMaxValueOnMap < r.biomeMaxValueOnMap)) continue;
                    r = getBiome;
                    continue;
                }
                r = getBiome;
                continue;
            }
            if (!(biomeMapData >= cp.biomesList.get((int)i).biomeMinValueOnMap) || !(biomeMapData <= cp.biomesList.get((int)i).biomeMaxValueOnMap)) continue;
            if (r != null) {
                if (!(cp.biomesList.get((int)i).biomeMaxValueOnMap - cp.biomesList.get((int)i).biomeMinValueOnMap < r.biomeMaxValueOnMap - r.biomeMinValueOnMap)) continue;
                r = cp.biomesList.get(i);
                continue;
            }
            r = cp.biomesList.get(i);
        }
        if (r == null) {
            r = cp.standardBiomeOnMap;
        }
        return r;
    }

    public static int getBiggestInterpolationQuality(WE_ChunkProvider cp) {
        int r = 0;
        for (int i = 0; i < cp.biomesList.size(); ++i) {
            if (cp.biomesList.get((int)i).biomeInterpolateQuality <= r) continue;
            r = cp.biomesList.get((int)i).biomeInterpolateQuality;
        }
        return r;
    }

    protected void generateOre(World world, Random rand, BlockPos pos, WorldGenerator worldGenerator, int amountPerChunk, int minY, int maxY) {
        for (int var5 = 0; var5 < amountPerChunk; ++var5) {
            int var7 = rand.nextInt(maxY - minY) + minY;
            worldGenerator.func_180709_b(world, rand, new BlockPos(pos.func_177958_n(), var7, pos.func_177952_p()));
        }
    }
}

