/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiProgress
extends GuiElement {
    private final IProgressInfoHandler handler;
    private final ProgressBar type;
    private final int xLocation;
    private final int yLocation;

    public GuiProgress(IProgressInfoHandler handler, ProgressBar type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiProgress.png"), gui, def);
        this.xLocation = x;
        this.yLocation = y;
        this.type = type;
        this.handler = handler;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.type.width, this.type.height);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiProgress.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.handler.isActive()) {
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.type.textureX, this.type.textureY, this.type.width, this.type.height);
            int innerOffsetX = 2;
            int displayInt = (int)(this.handler.getProgress() * (double)(this.type.width - 2 * innerOffsetX));
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation + innerOffsetX, guiHeight + this.yLocation, this.type.textureX + this.type.width + innerOffsetX, this.type.textureY, displayInt, this.type.height);
        }
        GuiProgress.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static abstract class IProgressInfoHandler {
        public abstract double getProgress();

        public boolean isActive() {
            return true;
        }
    }

    public static enum ProgressBar {
        BLUE(28, 11, 0, 0),
        YELLOW(28, 11, 0, 11),
        RED(28, 11, 0, 22),
        GREEN(28, 11, 0, 33),
        PURPLE(28, 11, 0, 44),
        STONE(28, 11, 0, 55),
        CRUSH(28, 11, 0, 66),
        LARGE_RIGHT(52, 10, 128, 0),
        LARGE_LEFT(52, 10, 128, 10),
        MEDIUM(36, 10, 128, 20),
        SMALL_RIGHT(32, 10, 128, 30),
        SMALL_LEFT(32, 10, 128, 40),
        BI(20, 8, 128, 50);

        public int width;
        public int height;
        public int textureX;
        public int textureY;

        private ProgressBar(int w, int h, int u, int v) {
            this.width = w;
            this.height = h;
            this.textureX = u;
            this.textureY = v;
        }
    }
}

