/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.world.biome;

import cofh.thermalfoundation.world.biome.BiomeFluxed;
import java.util.ArrayList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TFBiomes {
    public static final TFBiomes INSTANCE = new TFBiomes();
    private static ArrayList<WrappedBiomeEntry> biomeList = new ArrayList();
    public static BiomeFluxed biomeFluxed;

    private TFBiomes() {
    }

    public static void preInit() {
        biomeFluxed = new BiomeFluxed(new Biome.BiomeProperties("Fluxed").func_185410_a(0.8f).func_185395_b(0.7f).func_185398_c(0.1f).func_185400_d(0.0f));
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static void postInit() {
        for (WrappedBiomeEntry wrapped : biomeList) {
            wrapped.initialize();
        }
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        TFBiomes.register((IForgeRegistry<Biome>)registry, biomeFluxed, "meadow", BiomeManager.BiomeType.COOL, 7000000, true, true, true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
    }

    public static void register(IForgeRegistry<Biome> registry, Biome biome, String name, BiomeManager.BiomeType type, int weight, boolean enable, boolean spawn, boolean village, BiomeDictionary.Type ... biomeDictTypes) {
        if (!enable) {
            return;
        }
        biome.setRegistryName(name);
        registry.register((IForgeRegistryEntry)biome);
        for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
        }
        biomeList.add(new WrappedBiomeEntry(biome, type, weight, spawn, village));
    }

    public static class WrappedBiomeEntry {
        public final Biome biome;
        public final BiomeManager.BiomeType type;
        public final boolean spawn;
        public final boolean village;
        public final BiomeManager.BiomeEntry entry;

        public WrappedBiomeEntry(Biome biome, BiomeManager.BiomeType type, int weight, boolean spawn, boolean village) {
            this.biome = biome;
            this.type = type;
            this.spawn = spawn;
            this.village = village;
            this.entry = new BiomeManager.BiomeEntry(biome, weight);
        }

        public void initialize() {
            BiomeManager.addBiome((BiomeManager.BiomeType)this.type, (BiomeManager.BiomeEntry)this.entry);
            if (this.village) {
                BiomeManager.addVillageBiome((Biome)this.biome, (boolean)true);
            }
            if (this.spawn) {
                BiomeManager.addSpawnBiome((Biome)this.biome);
            }
        }
    }
}

