/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BlackHoleControllerTileReworked
extends CustomSidedTileEntity {
    private ItemStackHandler storage;
    private BlackHoleControllerItemHandler itemHandler = new BlackHoleControllerItemHandler(this);
    private BlackHoleControllerTankHandler tankHandler = new BlackHoleControllerTankHandler(this);

    public BlackHoleControllerTileReworked() {
        super(BlackHoleControllerTileReworked.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.storage = new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                BlackHoleControllerTileReworked.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.storage, EnumDyeColor.YELLOW, "Black hole units", 60, 22, 4, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals(Item.func_150898_a((Block)BlockRegistry.blackHoleUnitBlock)) || stack.func_77973_b().equals(Item.func_150898_a((Block)BlockRegistry.blackHoleTankBlock));
            }

            public boolean canExtractItem(int slot) {
                return super.canExtractItem(slot);
            }
        });
        this.addInventoryToStorage(this.storage, "storage");
    }

    protected boolean supportsAddons() {
        return false;
    }

    public ItemStackHandler getStorage() {
        return this.storage;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == null) {
            return false;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tankHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void dropItems() {
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            ItemStack stack = this.storage.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
        }
    }

    public boolean getAllowRedstoneControl() {
        return false;
    }

    protected boolean getShowPauseDrawerPiece() {
        return false;
    }

    protected void innerUpdate() {
    }

    private class BlackHoleControllerTankHandler
    implements IFluidHandler {
        private final BlackHoleControllerTileReworked tileReworked;

        private BlackHoleControllerTankHandler(BlackHoleControllerTileReworked tileReworked) {
            this.tileReworked = tileReworked;
        }

        public IFluidTankProperties[] getTankProperties() {
            ArrayList<IFluidTankProperties> propertiesList = new ArrayList<IFluidTankProperties>();
            for (int i = 0; i < BlackHoleControllerTileReworked.this.storage.getSlots(); ++i) {
                if (BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).func_190926_b() || !BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) continue;
                for (IFluidTankProperties tankProperty : ((IFluidHandlerItem)BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).getTankProperties()) {
                    propertiesList.add(tankProperty);
                }
            }
            return propertiesList.toArray(new IFluidTankProperties[propertiesList.size()]);
        }

        public int fill(FluidStack resource, boolean doFill) {
            for (int i = 0; i < BlackHoleControllerTileReworked.this.storage.getSlots(); ++i) {
                if (BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).func_190926_b() || !BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || ((IFluidHandlerItem)BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).fill(resource, false) == 0) continue;
                return ((IFluidHandlerItem)BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).fill(resource, doFill);
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            for (int i = 0; i < BlackHoleControllerTileReworked.this.storage.getSlots(); ++i) {
                if (BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).func_190926_b() || !BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || ((IFluidHandlerItem)BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(resource, false) == null) continue;
                return ((IFluidHandlerItem)BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(resource, doDrain);
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            for (int i = 0; i < BlackHoleControllerTileReworked.this.storage.getSlots(); ++i) {
                if (BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).func_190926_b() || !BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || ((IFluidHandlerItem)BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(maxDrain, false) == null) continue;
                return ((IFluidHandlerItem)BlackHoleControllerTileReworked.this.storage.getStackInSlot(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(maxDrain, doDrain);
            }
            return null;
        }
    }

    private class BlackHoleControllerItemHandler
    implements IItemHandler {
        private BlackHoleControllerTileReworked tile;

        public BlackHoleControllerItemHandler(BlackHoleControllerTileReworked tile) {
            this.tile = tile;
        }

        public int getSlots() {
            return 12;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (this.tile.getStorage().getStackInSlot(slot).func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (this.tile.getStorage().getStackInSlot(slot).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                return ((IItemHandler)this.tile.getStorage().getStackInSlot(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.tile.getStorage().getStackInSlot(slot).func_190926_b()) {
                return stack;
            }
            if (this.tile.getStorage().getStackInSlot(slot).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && !((IItemHandler)this.tile.getStorage().getStackInSlot(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).insertItem(0, stack, true).equals(stack)) {
                return ((IItemHandler)this.tile.getStorage().getStackInSlot(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).insertItem(0, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.tile.getStorage().getStackInSlot(slot).func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (this.tile.getStorage().getStackInSlot(slot).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                return ((IItemHandler)this.tile.getStorage().getStackInSlot(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).extractItem(0, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }
    }
}

