/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.spawn;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.grottol.EntityGrottol;
import com.bobmowzie.mowziesmobs.server.entity.lantern.EntityLantern;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public enum SpawnHandler {
    INSTANCE;

    public static Set<Biome> FROSTMAW_BIOMES;
    public static Set<Biome> BARAKO_BIOMES;
    public static Set<Biome> FERROUS_WROUGHTNAUT_BIOMES;
    private static final Map<String, BiomeDictionary.Type> BY_NAME;

    public void registerSpawnPlacementTypes() {
        EnumHelper.addSpawnPlacementType((String)"MMSPAWN", (BiPredicate)new BiPredicate<IBlockAccess, BlockPos>(){

            @Override
            public boolean test(IBlockAccess t, BlockPos pos) {
                IBlockState block = t.func_180495_p(pos.func_177977_b());
                boolean flag = block.func_177230_c() != Blocks.field_150357_h && block.func_177230_c() != Blocks.field_180401_cv && block.func_185904_a().func_76230_c();
                IBlockState iblockstateUp = t.func_180495_p(pos);
                IBlockState iblockstateUp2 = t.func_180495_p(pos.func_177984_a());
                flag = flag && WorldEntitySpawner.func_185331_a((IBlockState)iblockstateUp) && WorldEntitySpawner.func_185331_a((IBlockState)iblockstateUp2);
                return flag;
            }
        });
    }

    public void registerSpawns() {
        EntityLiving.SpawnPlacementType mmSpawn = EntityLiving.SpawnPlacementType.valueOf((String)"MMSPAWN");
        if (mmSpawn != null) {
            EntitySpawnPlacementRegistry.setPlacementType(EntityFoliaath.class, (EntityLiving.SpawnPlacementType)mmSpawn);
            EntitySpawnPlacementRegistry.setPlacementType(EntityLantern.class, (EntityLiving.SpawnPlacementType)mmSpawn);
            EntitySpawnPlacementRegistry.setPlacementType(EntityBarakoana.class, (EntityLiving.SpawnPlacementType)mmSpawn);
            EntitySpawnPlacementRegistry.setPlacementType(EntityGrottol.class, (EntityLiving.SpawnPlacementType)mmSpawn);
            EntitySpawnPlacementRegistry.setPlacementType(EntityNaga.class, (EntityLiving.SpawnPlacementType)mmSpawn);
        }
        for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
            BY_NAME.put(type.getName(), type);
        }
        if (ConfigHandler.FROSTMAW.generationData.generationFrequency > 0) {
            FROSTMAW_BIOMES = this.getBiomesFromConfig(ConfigHandler.FROSTMAW.generationData.biomeData);
        }
        if (ConfigHandler.BARAKO.generationData.generationFrequency > 0) {
            BARAKO_BIOMES = this.getBiomesFromConfig(ConfigHandler.BARAKO.generationData.biomeData);
        }
        if (ConfigHandler.FERROUS_WROUGHTNAUT.generationData.generationFrequency > 0) {
            FERROUS_WROUGHTNAUT_BIOMES = this.getBiomesFromConfig(ConfigHandler.FERROUS_WROUGHTNAUT.generationData.biomeData);
        }
        if (ConfigHandler.FOLIAATH.spawnData.spawnRate > 0) {
            Set<Biome> foliaathBiomes = this.getBiomesFromConfig(ConfigHandler.FOLIAATH.spawnData.biomeData);
            EntityRegistry.addSpawn(EntityFoliaath.class, (int)ConfigHandler.FOLIAATH.spawnData.spawnRate, (int)ConfigHandler.FOLIAATH.spawnData.minGroupSize, (int)ConfigHandler.FOLIAATH.spawnData.maxGroupSize, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])foliaathBiomes.toArray(new Biome[foliaathBiomes.size()]));
        }
        if (ConfigHandler.BARAKOA.spawnData.spawnRate > 0) {
            Set<Biome> barakoaBiomes = this.getBiomesFromConfig(ConfigHandler.BARAKOA.spawnData.biomeData);
            EntityRegistry.addSpawn(EntityBarakoana.class, (int)ConfigHandler.BARAKOA.spawnData.spawnRate, (int)ConfigHandler.BARAKOA.spawnData.minGroupSize, (int)ConfigHandler.BARAKOA.spawnData.maxGroupSize, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])barakoaBiomes.toArray(new Biome[barakoaBiomes.size()]));
        }
        if (ConfigHandler.GROTTOL.spawnData.spawnRate > 0) {
            Set<Biome> grottolBiomes = this.getBiomesFromConfig(ConfigHandler.GROTTOL.spawnData.biomeData);
            EntityRegistry.addSpawn(EntityGrottol.class, (int)ConfigHandler.GROTTOL.spawnData.spawnRate, (int)ConfigHandler.GROTTOL.spawnData.minGroupSize, (int)ConfigHandler.GROTTOL.spawnData.maxGroupSize, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])grottolBiomes.toArray(new Biome[grottolBiomes.size()]));
        }
        if (ConfigHandler.LANTERN.spawnData.spawnRate > 0) {
            Set<Biome> lanternBiomes = this.getBiomesFromConfig(ConfigHandler.LANTERN.spawnData.biomeData);
            EntityRegistry.addSpawn(EntityLantern.class, (int)ConfigHandler.LANTERN.spawnData.spawnRate, (int)ConfigHandler.LANTERN.spawnData.minGroupSize, (int)ConfigHandler.LANTERN.spawnData.maxGroupSize, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])lanternBiomes.toArray(new Biome[lanternBiomes.size()]));
        }
        if (ConfigHandler.NAGA.spawnData.spawnRate > 0) {
            Set<Biome> nagaBiomes = this.getBiomesFromConfig(ConfigHandler.NAGA.spawnData.biomeData);
            EntityRegistry.addSpawn(EntityNaga.class, (int)ConfigHandler.NAGA.spawnData.spawnRate, (int)ConfigHandler.NAGA.spawnData.minGroupSize, (int)ConfigHandler.NAGA.spawnData.maxGroupSize, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])nagaBiomes.toArray(new Biome[nagaBiomes.size()]));
        }
    }

    private Set<Biome> getBiomesFromConfig(ConfigHandler.BiomeData biomeData) {
        Field f = null;
        try {
            f = Biome.class.getDeclaredField("biomeName");
            f.setAccessible(true);
        }
        catch (Exception e) {
            System.out.println("Reflection failed");
        }
        HashSet<String> biomeWhitelistNames = new HashSet<String>(Arrays.asList(biomeData.biomeWhitelist));
        HashSet<String> biomeBlacklistNames = new HashSet<String>(Arrays.asList(biomeData.biomeBlacklist));
        HashSet<String> whiteOrBlacklistedBiomes = new HashSet<String>();
        HashSet<BiomeCombo> biomeCombos = new HashSet<BiomeCombo>();
        for (String biomeComboString : biomeData.biomeTypes) {
            BiomeCombo biomeCombo = new BiomeCombo(biomeComboString);
            biomeCombos.add(biomeCombo);
        }
        HashSet<Biome> toReturn = new HashSet<Biome>();
        for (Biome b : Biome.field_185377_q) {
            ResourceLocation biomeRegistryName = b.getRegistryName();
            if (biomeRegistryName == null) continue;
            String biomeName = biomeRegistryName.func_110623_a();
            if (biomeWhitelistNames.contains(biomeName)) {
                toReturn.add(b);
                whiteOrBlacklistedBiomes.add(biomeName);
                continue;
            }
            if (biomeBlacklistNames.contains(biomeName)) {
                whiteOrBlacklistedBiomes.add(biomeName);
                continue;
            }
            for (BiomeCombo biomeCombo : biomeCombos) {
                if (!biomeCombo.acceptsBiome(b)) continue;
                toReturn.add(b);
            }
        }
        for (String biomeName : biomeWhitelistNames) {
            if (whiteOrBlacklistedBiomes.contains(biomeName)) continue;
            System.out.println("Mowzie's Mobs config warning: No biome with name '" + biomeName + "'. Unable to whitelist.");
        }
        for (String biomeName : biomeBlacklistNames) {
            if (whiteOrBlacklistedBiomes.contains(biomeName)) continue;
            System.out.println("Mowzie's Mobs config warning: No biome with name '" + biomeName + "'. Unable to blacklist.");
        }
        return toReturn;
    }

    static {
        BY_NAME = new HashMap<String, BiomeDictionary.Type>();
    }

    private class BiomeCombo {
        BiomeDictionary.Type[] neededTypes;
        boolean[] inverted;

        private BiomeCombo(String biomeComboString) {
            String[] typeStrings = biomeComboString.toUpperCase().replace(" ", "").split(",");
            this.neededTypes = new BiomeDictionary.Type[typeStrings.length];
            this.inverted = new boolean[typeStrings.length];
            for (int i = 0; i < typeStrings.length; ++i) {
                if (typeStrings[i].length() == 0) continue;
                this.inverted[i] = typeStrings[i].charAt(0) == '!';
                String name = typeStrings[i].replace("!", "");
                BiomeDictionary.Type neededType = (BiomeDictionary.Type)BY_NAME.get(name);
                if (neededType == null) {
                    System.out.println("Mowzie's Mobs config warning: No biome dictionary type with name '" + name + "'. Unable to check for type.");
                }
                this.neededTypes[i] = neededType;
            }
        }

        private boolean acceptsBiome(Biome biome) {
            Set thisTypes = BiomeDictionary.getTypes((Biome)biome);
            for (int i = 0; i < this.neededTypes.length; ++i) {
                if (this.neededTypes[i] == null || !(!this.inverted[i] ? !thisTypes.contains(this.neededTypes[i]) : thisTypes.contains(this.neededTypes[i]))) continue;
                return false;
            }
            return true;
        }
    }
}

