/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.block.BlockProperties;
import thelm.jaopca.api.utils.Utils;

public class ModuleBlock
extends ModuleBase {
    public static final BlockProperties METAL_BLOCK_PROPERTIES = new BlockProperties().setMaterialMapColor(Material.field_151573_f).setHardnessFunc(entry -> 5.0f).setResistanceFunc(entry -> 10.0f).setSoundType(SoundType.field_185852_e).setBeaconBase(true);
    public static final ItemEntry BLOCK_ENTRY = new ItemEntry(EnumEntryType.BLOCK, "block", new ModelResourceLocation("jaopca:block#normal"), (Collection<String>)ImmutableList.of((Object)"Iron", (Object)"Gold", (Object)"Coal", (Object)"Lapis", (Object)"Diamond", (Object)"Emerald", (Object)"Prismarine", (Object)"Redstone")).setProperties(METAL_BLOCK_PROPERTIES).setOreTypes(EnumOreType.values());

    @Override
    public String getName() {
        return "block";
    }

    public List<ItemEntry> getItemRequests() {
        return Lists.newArrayList((Object[])new ItemEntry[]{BLOCK_ENTRY});
    }

    @Override
    public void init() {
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"block")) {
            String s = "ingot";
            switch (entry.getOreType()) {
                case GEM: 
                case GEM_ORELESS: {
                    s = "gem";
                    break;
                }
                case DUST: {
                    s = "dust";
                    break;
                }
            }
            Utils.addShapelessOreRecipe(Utils.getOreStack("block", entry, 1), s + entry.getOreName(), s + entry.getOreName(), s + entry.getOreName(), s + entry.getOreName(), s + entry.getOreName(), s + entry.getOreName(), s + entry.getOreName(), s + entry.getOreName(), s + entry.getOreName());
            Utils.addShapelessOreRecipe(Utils.getOreStack(s, entry, 9), "block" + entry.getOreName());
        }
    }
}

