/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WorldUtil {
    public static ArrayList<TileEntity> getTouchingTileEntities(World world, BlockPos pos) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            list.add(world.func_175625_s(pos.func_177972_a(facing)));
        }
        return list;
    }

    public static <T> ArrayList<T> getTouchingTileEntitiesByClass(World world, BlockPos pos, Class<T> clazz) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing));
            if (!clazz.isInstance(tileEntity)) continue;
            list.add(tileEntity);
        }
        return list;
    }

    public static ArrayList<IBlockState> getTouchingBlockStates(World world, BlockPos pos) {
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            list.add(world.func_180495_p(pos.func_177972_a(facing)));
        }
        return list;
    }

    public static List<RayTraceResult> traceEntities(Entity toIgnore, Vec3d base, Vec3d target, World world) {
        Entity pointedEntity = null;
        RayTraceResult result = null;
        Vec3d vec3d3 = null;
        AxisAlignedBB search = new AxisAlignedBB(base.field_72450_a, base.field_72448_b, base.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c).func_72314_b(0.5, 0.5, 0.5);
        List list = world.func_175674_a(toIgnore, search, Predicates.and((Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L()));
        ArrayList<RayTraceResult> resultList = new ArrayList<RayTraceResult>();
        for (Entity entity1 : list) {
            AxisAlignedBB aabb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = aabb.func_72327_a(base, target);
            if (aabb.func_72318_a(base)) {
                pointedEntity = entity1;
                vec3d3 = raytraceresult == null ? base : raytraceresult.field_72307_f;
            } else if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
            }
            if (pointedEntity != null) {
                result = new RayTraceResult(pointedEntity, vec3d3);
            }
            if (result == null) continue;
            resultList.add(result);
        }
        resultList.sort(Comparator.comparingDouble(o -> base.func_72438_d(o.field_72307_f)));
        return resultList;
    }
}

