/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.computer;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import erogenousbeef.bigreactors.common.multiblock.computer.ReactorComputer;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorComputerPort;
import it.zerono.mods.zerocore.lib.compat.LuaHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")})
public class ReactorComputerCC
extends ReactorComputer
implements IPeripheral {
    private static final String[] METHODS_NAMES;

    private ReactorComputerCC(@Nonnull TileEntityReactorComputerPort computerPort) {
        super(computerPort);
    }

    public static ReactorComputer create(TileEntityReactorComputerPort tileEntity) {
        return new ReactorComputerCC(tileEntity);
    }

    @Nonnull
    @Optional.Method(modid="computercraft")
    public String getType() {
        return "BigReactors-Reactor";
    }

    @Nonnull
    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return METHODS_NAMES;
    }

    @Optional.Method(modid="computercraft")
    public void attach(@Nonnull IComputerAccess iComputerAccess) {
    }

    @Optional.Method(modid="computercraft")
    public void detach(@Nonnull IComputerAccess iComputerAccess) {
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(@Nullable IPeripheral other) {
        return null != other && this.hashCode() == other.hashCode();
    }

    @Nullable
    @Optional.Method(modid="computercraft")
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext luaContext, int methodIdx, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        try {
            ComputerMethod method = ComputerMethod.fromIndex(methodIdx);
            switch (method) {
                case getConnected: {
                    return new Object[]{this.getConnected()};
                }
                case getActive: {
                    return new Object[]{this.getActive()};
                }
                case getFuelTemperature: {
                    return new Object[]{Float.valueOf(this.getFuelTemperature())};
                }
                case getCasingTemperature: {
                    return new Object[]{Float.valueOf(this.getCasingTemperature())};
                }
                case getEnergyStored: {
                    return new Object[]{this.getEnergyStored()};
                }
                case getFuelAmount: {
                    return new Object[]{this.getFuelAmount()};
                }
                case getWasteAmount: {
                    return new Object[]{this.getWasteAmount()};
                }
                case getFuelAmountMax: {
                    return new Object[]{this.getFuelAmountMax()};
                }
                case getControlRodName: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)1);
                    return new Object[]{this.getControlRodName(LuaHelper.getIntFromArgs((Object[])arguments, (int)0))};
                }
                case getNumberOfControlRods: {
                    return new Object[]{this.getNumberOfControlRods()};
                }
                case getControlRodLevel: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)1);
                    return new Object[]{this.getControlRodLevel(LuaHelper.getIntFromArgs((Object[])arguments, (int)0))};
                }
                case getEnergyProducedLastTick: {
                    return new Object[]{Float.valueOf(this.getEnergyProducedLastTick())};
                }
                case getHotFluidProducedLastTick: {
                    return new Object[]{Float.valueOf(this.getHotFluidProducedLastTick())};
                }
                case getCoolantAmount: {
                    return new Object[]{this.getCoolantAmount()};
                }
                case getCoolantAmountMax: {
                    return new Object[]{this.getCoolantAmountMax()};
                }
                case getCoolantType: {
                    return new Object[]{this.getCoolantType()};
                }
                case getHotFluidAmount: {
                    return new Object[]{this.getHotFluidAmount()};
                }
                case getHotFluidAmountMax: {
                    return new Object[]{this.getHotFluidAmountMax()};
                }
                case getHotFluidType: {
                    return new Object[]{this.getHotFluidType()};
                }
                case getFuelReactivity: {
                    return new Object[]{Float.valueOf(this.getFuelReactivity())};
                }
                case getFuelConsumedLastTick: {
                    return new Object[]{Float.valueOf(this.getFuelConsumedLastTick())};
                }
                case getMinimumCoordinate: {
                    BlockPos coords = this.getMinimumCoordinate();
                    return new Object[]{coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()};
                }
                case getMaximumCoordinate: {
                    BlockPos coords = this.getMaximumCoordinate();
                    return new Object[]{coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()};
                }
                case getControlRodLocation: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)1);
                    return new Object[]{this.getControlRodLocation(LuaHelper.getIntFromArgs((Object[])arguments, (int)0))};
                }
                case isActivelyCooled: {
                    return new Object[]{this.isActivelyCooled()};
                }
                case setActive: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)1);
                    this.setActive(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0));
                    return null;
                }
                case setControlRodLevel: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)2);
                    this.setControlRodLevel(LuaHelper.getIntFromArgs((Object[])arguments, (int)0), LuaHelper.getIntFromArgs((Object[])arguments, (int)1, (int)0, (int)100));
                    return null;
                }
                case setAllControlRodLevels: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)1);
                    this.setAllControlRodLevels(LuaHelper.getIntFromArgs((Object[])arguments, (int)0, (int)0, (int)100));
                    return null;
                }
                case setControlRodName: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)2);
                    this.setControlRodName(LuaHelper.getIntFromArgs((Object[])arguments, (int)0), LuaHelper.getStringFromArgs((Object[])arguments, (int)1));
                    return null;
                }
                case doEjectWaste: {
                    this.doEjectWaste();
                    return null;
                }
                case doEjectFuel: {
                    this.doEjectFuel();
                    return null;
                }
                case getEnergyCapacity: {
                    return new Object[]{this.getEnergyCapacity()};
                }
                case getMultiblockAssembled: {
                    return new Object[]{this.getMultiblockAssembled()};
                }
            }
            throw new Exception("Method not implemented");
        }
        catch (Exception ex) {
            throw new LuaException(ex.getMessage());
        }
    }

    static {
        ComputerMethod[] methods = ComputerMethod.values();
        METHODS_NAMES = new String[methods.length];
        for (ComputerMethod method : methods) {
            ReactorComputerCC.METHODS_NAMES[method.ordinal()] = method.toString();
        }
    }

    private static enum ComputerMethod {
        getConnected,
        getActive,
        getFuelTemperature,
        getCasingTemperature,
        getEnergyStored,
        getFuelAmount,
        getWasteAmount,
        getFuelAmountMax,
        getControlRodName,
        getNumberOfControlRods,
        getControlRodLevel,
        getEnergyProducedLastTick,
        getHotFluidProducedLastTick,
        getCoolantAmount,
        getCoolantAmountMax,
        getCoolantType,
        getHotFluidAmount,
        getHotFluidAmountMax,
        getHotFluidType,
        getFuelReactivity,
        getFuelConsumedLastTick,
        getMinimumCoordinate,
        getMaximumCoordinate,
        getControlRodLocation,
        isActivelyCooled,
        setActive,
        setControlRodLevel,
        setAllControlRodLevels,
        setControlRodName,
        doEjectWaste,
        doEjectFuel,
        getEnergyCapacity,
        getMultiblockAssembled;


        public static Boolean isValidIndex(int index) {
            return index >= 0 && index < ComputerMethod.values().length;
        }

        public static ComputerMethod fromIndex(int index) {
            if (!ComputerMethod.isValidIndex(index).booleanValue()) {
                throw new IndexOutOfBoundsException("Invalid method index");
            }
            return ComputerMethod.values()[index];
        }
    }
}

