/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import gtclassic.api.helpers.GTHelperStack;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.machine.low.logic.crafter.CraftingRecipe;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.container.ContainerAutocraftingTable;

public class TileEntityAutocraftingTable
extends TileEntityElecMachine
implements ITickable,
IHasGui {
    public static final ResourceLocation GUI_LOCATION = new ResourceLocation("ic2c_extras", "textures/gui/autocraftingtable.png");
    protected static final int[] slotInputs = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    protected static final int[] slotContainer = new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18};
    protected static final int[] slotOutputs = new int[]{19};
    public List<ItemStack> currentRecipe = new ArrayList<ItemStack>();
    public CraftingRecipe craftingThingy = new CraftingRecipe();

    public TileEntityAutocraftingTable() {
        super(29, 32);
        this.maxEnergy = 10000;
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, slotInputs);
        handler.registerDefaultSlotAccess(AccessRule.Export, slotOutputs);
        handler.registerDefaultSlotAccess(AccessRule.Export, slotContainer);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), slotInputs);
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), slotOutputs);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, slotContainer);
        handler.registerInputFilter(CommonFilters.Anything, slotInputs);
        handler.registerSlotType(SlotType.Input, slotInputs);
        handler.registerSlotType(SlotType.Output, slotOutputs);
        handler.registerSlotType(SlotType.Output, slotContainer);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("currentRecipe", 10);
        this.currentRecipe.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            this.currentRecipe.add(new ItemStack(data));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.currentRecipe.size(); ++i) {
            NBTTagCompound data = new NBTTagCompound();
            this.currentRecipe.get(i).func_77955_b(data);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("currentRecipe", (NBTBase)list);
        return nbt;
    }

    public boolean canInteractWith(EntityPlayer var1) {
        return !this.func_145837_r();
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerAutocraftingTable(player.field_71071_by, this);
    }

    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return facing != this.getFacing() && facing.func_176740_k().func_176722_c();
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.tryImportItems(this.getFacing().func_176734_d());
            ItemStack mStack = this.getStackInSlot(27);
            if (!this.currentRecipe.isEmpty() && !mStack.func_190926_b() && GTHelperStack.canMerge((ItemStack)mStack, (ItemStack)((ItemStack)this.inventory.get(28))) && this.energy >= 50) {
                GTHelperStack.tryCondenseInventory((TileEntityMachine)this, (int)0, (int)9);
                int recipeMatches = 0;
                for (int i = 0; i < 9; ++i) {
                    if (GTHelperStack.containsWithSizeFuzzy(this.currentRecipe, (ItemStack)this.getStackInSlot(i)) == -1) continue;
                    ++recipeMatches;
                }
                if (recipeMatches >= this.currentRecipe.size()) {
                    int tooMatch = recipeMatches;
                    for (int i = 0; i < 9; ++i) {
                        int currentIndex = GTHelperStack.containsWithSizeFuzzy(this.currentRecipe, (ItemStack)this.getStackInSlot(i));
                        if (currentIndex == -1 || tooMatch <= 0) continue;
                        ItemStack matchedSlot = this.getStackInSlot(i);
                        this.tryToDamageItems(matchedSlot);
                        if (matchedSlot.func_190926_b()) continue;
                        this.tryToShiftContainerItems(matchedSlot);
                        matchedSlot.func_190918_g(this.currentRecipe.get(currentIndex).func_190916_E());
                        --tooMatch;
                    }
                    if (tooMatch == 0) {
                        int oldCount = this.getStackInSlot(28).func_190916_E();
                        this.setStackInSlot(28, GTHelperStack.copyWithSize((ItemStack)mStack.func_77946_l(), (int)(oldCount + mStack.func_190916_E())));
                        this.useEnergy(50);
                    }
                }
                this.tryExportItems(this.getFacing(), 28);
            }
        }
    }

    public void tryToDamageItems(ItemStack stack) {
        if (stack.func_77984_f() && this.isRendering()) {
            stack.func_96631_a(1, this.field_145850_b.field_73012_v, null);
        }
    }

    public void tryToShiftContainerItems(ItemStack container) {
        if (container.func_77973_b().hasContainerItem(container)) {
            ItemStack cItem = container.func_77973_b().getContainerItem(container);
            for (int i = 9; i < 18; ++i) {
                if (!GTHelperStack.canMerge((ItemStack)cItem, (ItemStack)this.getStackInSlot(i))) continue;
                int oldCount = this.getStackInSlot(i).func_190916_E();
                this.setStackInSlot(i, GTHelperStack.copyWithSize((ItemStack)cItem, (int)(oldCount + cItem.func_190916_E())));
                return;
            }
        }
    }

    public void tryImportItems(EnumFacing side) {
        BlockPos importPos = this.func_174877_v().func_177972_a(side);
        if (!this.func_145831_w().func_175667_e(importPos)) {
            return;
        }
        IItemTransporter slave = TransporterManager.manager.getTransporter((Object)this.func_145831_w().func_175625_s(importPos), true);
        IItemTransporter controller = TransporterManager.manager.getTransporter((Object)this, true);
        if (slave != null && controller != null) {
            ItemStack added;
            ItemStack stack;
            int limit = controller.getSizeInventory(side);
            for (int i = 0; i < limit && !(stack = slave.removeItem(CommonFilters.Anything, side.func_176734_d(), 1, false)).func_190926_b() && (added = controller.addItem(stack, side, true)).func_190916_E() > 0; ++i) {
                slave.removeItem((IFilter)new BetterBasicItemFilter(added), side.func_176734_d(), 1, true);
            }
        }
    }

    public void tryExportItems(EnumFacing side, int ... slots) {
        BlockPos exportPos = this.func_174877_v().func_177972_a(side);
        if (!this.func_145831_w().func_175667_e(exportPos)) {
            return;
        }
        IItemTransporter slave = TransporterManager.manager.getTransporter((Object)this.func_145831_w().func_175625_s(exportPos), false);
        if (slave != null) {
            for (int i : slots) {
                int added = slave.addItem(this.getStackInSlot(i).func_77946_l(), side.func_176734_d(), true).func_190916_E();
                if (added <= 0) continue;
                this.getStackInSlot(i).func_190918_g(added);
                break;
            }
        }
    }

    public boolean supportsNotify() {
        return true;
    }

    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    public ResourceLocation getGuiTexture() {
        return GUI_LOCATION;
    }

    public static class BetterBasicItemFilter
    implements IFilter {
        ItemStack item;

        public BetterBasicItemFilter(Item item) {
            this(new ItemStack(item));
        }

        public BetterBasicItemFilter(Block block) {
            this(new ItemStack(block));
        }

        public BetterBasicItemFilter(ItemStack par1) {
            this.item = par1;
        }

        public boolean matches(ItemStack stack) {
            return StackUtil.isStackEqual((ItemStack)this.item.func_77946_l(), (ItemStack)stack, (boolean)false, (boolean)false);
        }
    }
}

