/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util;

import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.util.misc.StackUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    public static boolean canMerge(ItemStack stack, ItemStack toCompare) {
        return StackHelper.canMerge(stack, toCompare, stack.func_77976_d());
    }

    public static boolean canMerge(ItemStack stack, ItemStack toCompare, int maxCount) {
        return StackHelper.isEqual(stack, toCompare) && toCompare.func_190916_E() + stack.func_190916_E() <= maxCount || toCompare.func_190926_b();
    }

    public static boolean isEqual(ItemStack stack, ItemStack toCompare) {
        return StackUtil.isStackEqual((ItemStack)stack, (ItemStack)toCompare, (boolean)false, (boolean)false);
    }

    public static boolean isEqualCompareOreDict(ItemStack stack, ItemStack toCompare) {
        return StackUtil.isStackEqual((ItemStack)stack, (ItemStack)toCompare, (boolean)false, (boolean)false) || StackHelper.sharesOreDict(stack, toCompare);
    }

    public static boolean sharesOreDict(ItemStack stack, ItemStack toCompare) {
        if (!stack.func_190926_b() && OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
            for (int i = 0; i < OreDictionary.getOreIDs((ItemStack)stack).length; ++i) {
                if (!StackHelper.matchOreDict(toCompare, OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canOutputStack(TileEntityMachine tile, ItemStack stack, int slot) {
        if (((ItemStack)tile.inventory.get(slot)).func_190926_b()) {
            return true;
        }
        int count = ((ItemStack)tile.inventory.get(slot)).func_190916_E();
        boolean hasRoom = count < ((ItemStack)tile.inventory.get(slot)).func_77976_d();
        return hasRoom && StackHelper.isEqual(tile.getStackInSlot(slot), stack);
    }

    public static boolean isSlotEmpty(TileEntityMachine tile, int slot) {
        return ((ItemStack)tile.inventory.get(slot)).func_190926_b();
    }

    public static boolean isSlotFull(TileEntityMachine tile, int slot) {
        if (((ItemStack)tile.inventory.get(slot)).func_190926_b()) {
            return false;
        }
        return ((ItemStack)tile.inventory.get(slot)).func_190916_E() == ((ItemStack)tile.inventory.get(slot)).func_77976_d();
    }

    public int getSlotStackCount(TileEntityMachine tile, int slot) {
        if (((ItemStack)tile.inventory.get(slot)).func_190926_b()) {
            return 0;
        }
        return tile.getStackInSlot(slot).func_190916_E();
    }

    public static List<ItemStack> mergeItems(List<ItemStack> a, List<ItemStack> b) {
        int size = b.size();
        for (int i = 0; i < size; ++i) {
            if (b.get(i).func_190926_b()) continue;
            int position = StackHelper.contains(a, b.get(i));
            if (position == -1) {
                a.add(b.get(i));
                continue;
            }
            a.get(position).func_190917_f(b.get(i).func_190916_E());
        }
        return a;
    }

    public static int contains(List<ItemStack> list, ItemStack item) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!StackUtil.isStackEqual((ItemStack)list.get(i), (ItemStack)item)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchOreDict(ItemStack stack, String entry) {
        if (!stack.func_190926_b() && OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
            for (int i = 0; i < OreDictionary.getOreIDs((ItemStack)stack).length; ++i) {
                if (!OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[i]).contains(entry)) continue;
                return true;
            }
        }
        return false;
    }
}

