/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.io.IOException;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationItemInventory;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiPneumaticInventoryItem
extends GuiPneumaticContainerBase<TileEntityChargingStation> {
    protected final ItemStack itemStack;
    private GuiButton guiBackButton;

    public GuiPneumaticInventoryItem(ContainerChargingStationItemInventory container, TileEntityChargingStation te) {
        super(container, te, "pneumaticcraft:textures/gui/gui_pneumatic_armor.png");
        this.itemStack = te.getPrimaryInventory().getStackInSlot(0);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.guiBackButton = new GuiButton(2, xStart + 90, yStart + 15, 25, 20, "\u2b05");
        this.field_146292_n.add(this.guiBackButton);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        pressureStatText.add("\u00a77Current Pressure:");
        ItemStack stack = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0);
        float curPressure = ((TileEntityChargingStation)this.te).chargingItemPressure;
        int volume = UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME, stack) * 5000 + this.getDefaultVolume();
        pressureStatText.add("\u00a70" + (double)Math.round(curPressure * 10.0f) / 10.0 + " bar.");
        pressureStatText.add("\u00a77Current Air:");
        pressureStatText.add("\u00a70" + (double)Math.round(curPressure * (float)volume) + " mL.");
        pressureStatText.add("\u00a77Volume:");
        pressureStatText.add("\u00a70" + this.getDefaultVolume() + " mL.");
        if (volume > this.getDefaultVolume()) {
            pressureStatText.add("\u00a70" + (double)Math.round(volume - this.getDefaultVolume()) + " mL. (Volume Upgrades)");
            pressureStatText.add("\u00a70--------+");
            pressureStatText.add("\u00a70" + (double)Math.round(volume) + " mL.");
        }
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    protected abstract int getDefaultVolume();

    @Override
    protected void func_146284_a(GuiButton button) {
        NetworkHandler.sendToServer(new PacketGuiButton(button.field_146127_k));
    }

    @Override
    protected void func_146979_b(int x, int y) {
        String containerName = this.itemStack.func_82833_r();
        this.field_146289_q.func_78276_b(containerName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(containerName) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.tab.upgrades", (Object[])new Object[0]), 36, 14, 0x404040);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        IPressurizable p = (IPressurizable)this.itemStack.func_77973_b();
        GuiUtils.drawPressureGauge(this.field_146289_q, 0.0f, p.maxPressure(this.itemStack), p.maxPressure(this.itemStack), 0.0f, ((TileEntityChargingStation)this.te).chargingItemPressure, xStart + this.field_146999_f * 3 / 4 + 8, yStart + this.field_147000_g / 4 + 4, this.field_73735_i);
    }

    @Override
    protected Point getGaugeLocation() {
        return null;
    }

    @Override
    protected void func_73869_a(char key, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.guiBackButton);
        } else {
            super.func_73869_a(key, keyCode);
        }
    }
}

