/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.List;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.widget.WidgetBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class WidgetTemperature
extends WidgetBase {
    private int[] scales;
    protected final IHeatExchangerLogic logic;
    private final int minTemp;
    private final int maxTemp;

    public WidgetTemperature(int id, int x, int y, int minTemp, int maxTemp, IHeatExchangerLogic logic, int ... scales) {
        super(id, x, y, 13, 50);
        this.scales = scales;
        this.logic = logic;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp - 273;
    }

    public void setScales(int ... scales) {
        this.scales = scales;
    }

    public int[] getScales() {
        return this.scales;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        GlStateManager.func_179140_f();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_TEMPERATURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)(this.x + 6), (int)this.y, (float)6.0f, (float)0.0f, (int)7, (int)50, (float)18.0f, (float)50.0f);
        int barLength = (this.logic.getTemperatureAsInt() - this.minTemp) * 48 / this.maxTemp;
        barLength = MathHelper.func_76125_a((int)barLength, (int)0, (int)48);
        Gui.func_146110_a((int)(this.x + 7), (int)(this.y + 1 + 48 - barLength), (float)13.0f, (float)(48 - barLength), (int)5, (int)barLength, (float)18.0f, (float)50.0f);
        for (int scale : this.scales) {
            int scaleY = 48 - (scale - this.minTemp) * 48 / this.maxTemp;
            int v = scaleY < 0 ? 6 : (scaleY > 48 ? 12 : 0);
            Gui.func_146110_a((int)this.x, (int)(this.y - 1 + MathHelper.func_76125_a((int)scaleY, (int)0, (int)48)), (float)0.0f, (float)v, (int)6, (int)6, (float)18.0f, (float)50.0f);
        }
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shift) {
        curTip.add("Temperature: " + (this.logic.getTemperatureAsInt() - 273) + "\u00b0C");
    }
}

